/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.lang.Strings;
import org.openurp.base.time.Terms;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.ExecutiveCourseGroup;
import org.openurp.edu.program.model.PlanCourse;

public class PlanTermCreditTool {
    public static String normalizeTerms(String terms) {
        Object[] arr = terms.replaceAll("\\s", "").replaceAll("^,", "").replaceAll(",$", "").split(",");
        try {
            Arrays.sort(arr, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return Integer.valueOf(o1) - Integer.valueOf(o2);
                }
            });
        }
        catch (Exception e) {
            return "," + Strings.join((Object[])arr, (char)',') + ",";
        }
        if (arr.length == 1 && ((String)arr[0]).equals("*")) {
            return arr[0];
        }
        return "," + Strings.join((Object[])arr, (char)',') + ",";
    }

    public static String mergeTermCredits(String termCredits1, String termCredits2) {
        if (Strings.isEmpty((CharSequence)termCredits1)) {
            return termCredits2;
        }
        if (Strings.isEmpty((CharSequence)termCredits2)) {
            return termCredits1;
        }
        String[] credits1 = termCredits1.replaceAll("^,", "").replaceAll(",$", "").split(",");
        String[] credits2 = termCredits2.replaceAll("^,", "").replaceAll(",$", "").split(",");
        String[] credits3 = new String[credits1.length];
        for (int i = 0; i < credits1.length; ++i) {
            try {
                credits3[i] = String.valueOf(Float.valueOf(credits1[i]).floatValue() + Float.valueOf(credits2[i]).floatValue()).replaceAll(".0$", "");
                continue;
            }
            catch (Exception e) {
                credits3[i] = credits2[i];
            }
        }
        return "," + Strings.join((String[])credits3, (String)",") + ",";
    }

    public static String buildCourseGroupTermCredits(Float[] termCredits, Integer oldTermsCount, Integer newTermsCount) {
        StringBuffer result = new StringBuffer(",");
        if (newTermsCount < oldTermsCount) {
            int i;
            int count = oldTermsCount - newTermsCount;
            Float remain = Float.valueOf(0.0f);
            for (i = 0; i < count; ++i) {
                remain = Float.valueOf(remain.floatValue() + termCredits[newTermsCount + i].floatValue());
            }
            for (i = 0; i < newTermsCount; ++i) {
                if (i == newTermsCount - 1) {
                    result.append(termCredits[i].floatValue() + remain.floatValue() + ",");
                    continue;
                }
                result.append(termCredits[i] + ",");
            }
        } else {
            for (int i = 0; i < oldTermsCount; ++i) {
                result.append(termCredits[i] + ",");
            }
            int count = newTermsCount - oldTermsCount;
            for (int i = 0; i < count; ++i) {
                result.append("0,");
            }
        }
        return result.toString().replace(".0", "");
    }

    public static Terms buildPlanCourseTerms(Terms terms, Integer oldTermsCount, Integer newTermsCount) {
        if (newTermsCount < oldTermsCount) {
            Integer[] termArr = terms.getTermList().toArray(new Integer[0]);
            for (int i = 0; i < termArr.length; ++i) {
                if (termArr[i] <= newTermsCount) continue;
                termArr[i] = newTermsCount;
            }
            Integer prev = -1;
            ArrayList<Integer> termArr_ = new ArrayList<Integer>();
            for (int i = 0; i < termArr.length; ++i) {
                if (prev == termArr[i]) continue;
                termArr_.add(termArr[i]);
                prev = termArr[i];
            }
            return new Terms("," + Strings.join((Object[])termArr_.toArray(new Integer[0]), (char)',') + ",");
        }
        return terms;
    }

    public static void updateTermsCount(CoursePlan plan, Integer oldTermsCount, Integer newTermsCount, EntityDao entityDao) {
        for (ExecutiveCourseGroup executiveCourseGroup : plan.getGroups()) {
            String newCreditPerTerms = PlanTermCreditTool.buildCourseGroupTermCredits(PlanTermCreditTool.transformToFloat(executiveCourseGroup.getTermCredits()), oldTermsCount, newTermsCount);
            executiveCourseGroup.setTermCredits(newCreditPerTerms);
            for (PlanCourse planCourse : executiveCourseGroup.getPlanCourses()) {
                Terms terms = PlanTermCreditTool.buildPlanCourseTerms(planCourse.getTerms(), oldTermsCount, newTermsCount);
                planCourse.setTerms(terms);
                entityDao.saveOrUpdate(new Object[]{planCourse});
            }
            entityDao.saveOrUpdate(new Object[]{executiveCourseGroup});
        }
    }

    public static Float[] transformToFloat(String strIds) {
        String[] ids = Strings.split((String)strIds, (String)",");
        Float[] idsOfFloat = new Float[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            idsOfFloat[i] = new Float(ids[i]);
        }
        return idsOfFloat;
    }
}

