/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.openurp.base.model.Department;
import org.openurp.base.service.DepartmentService;

public class DepartmentServiceImpl
extends BaseServiceImpl
implements DepartmentService {
    @Override
    public List<Department> getDepartments() {
        return this.entityDao.search((QueryBuilder)OqlBuilder.from(Department.class));
    }

    @Override
    public Department getDepartment(Integer id) {
        if (null == id) {
            return null;
        }
        return (Department)this.entityDao.get(Department.class, (Serializable)id);
    }

    @Override
    public List<Department> getColleges() {
        return this.entityDao.search((QueryBuilder)OqlBuilder.from(Department.class, (String)"depart").where("depart.teaching =true and depart.beginOn <= :now and (depart.endOn is null or depart.endOn >= :now)", (Object)new Date()).orderBy("depart.code"));
    }

    @Override
    public List<Department> getAdministatives() {
        return this.entityDao.search((QueryBuilder)OqlBuilder.from(Department.class, (String)"depart").where("depart.teaching =false depart.beginOn <= :now and (depart.endOn is null or depart.endOn >= :now)", (Object)new Date()).orderBy("depart.code"));
    }

    @Override
    public List<Department> getDepartments(Integer[] ids) {
        if (null == ids || ids.length < 1) {
            return Collections.EMPTY_LIST;
        }
        return this.entityDao.get(Department.class, (Serializable[])ids);
    }

    @Override
    public List<Department> getAdministatives(String idSeq) {
        return this.getAdministatives(Strings.transformToInt((String[])Strings.split((String)idSeq)));
    }

    @Override
    public List<Department> getAdministatives(Integer[] ids) {
        if (null == ids || ids.length < 1) {
            return null;
        }
        return this.entityDao.search((QueryBuilder)OqlBuilder.from(Department.class, (String)"depart").where("depart.teaching =false").where("depart.id in (:ids)", (Object)ids));
    }

    @Override
    public List<Department> getColleges(String idSeq) {
        return this.getColleges(Strings.transformToInt((String[])Strings.split((String)idSeq)));
    }

    @Override
    public List<Department> getColleges(Integer[] ids) {
        if (null == ids || ids.length < 1) {
            return null;
        }
        return this.entityDao.search((QueryBuilder)OqlBuilder.from(Department.class, (String)"depart").where("depart.teaching =true").where("depart.id in (:ids)", (Object)ids));
    }

    @Override
    public List<Department> getTeachDeparts(String idSeq) {
        if (Strings.isEmpty((CharSequence)idSeq)) {
            return Collections.EMPTY_LIST;
        }
        return this.entityDao.search((QueryBuilder)OqlBuilder.from(Department.class, (String)"depart").where("depart.teaching=true").where("depart.id in (:ids)", (Object)Strings.transformToInt((String[])Strings.split((String)idSeq))));
    }

    @Override
    public Collection<Department> getRelatedDeparts(String stdTypeIds) {
        return this.entityDao.search((QueryBuilder)OqlBuilder.from(Department.class, (String)"depart").join("depart.stdTypes", "stdType").where("stdType.id in (:stdTypeIds)", (Object)Strings.transformToInt((String[])Strings.split((String)stdTypeIds))).select("select distinct depart "));
    }

    @Override
    public void saveOrUpdate(Department department) {
        department.setUpdatedAt(new java.sql.Date(System.currentTimeMillis()));
        this.entityDao.saveOrUpdate(new Object[]{department});
    }

    @Override
    public void removeDepartment(Integer id) {
        if (null == id) {
            return;
        }
        this.entityDao.remove(Department.class, "id", new Object[]{id});
    }

    @Override
    public List<Department> getDepartments(String idSeq) {
        return this.getDepartments(Strings.transformToInt((String[])Strings.split((String)idSeq)));
    }

    @Override
    public List<Department> getTeachDeparts() {
        return this.entityDao.search((QueryBuilder)OqlBuilder.from(Department.class, (String)"department").where("department.teaching=true").where("department.beginOn <= :now and (department.endOn is null or department.endOn >= :now)", (Object)new Date()).orderBy("department.code"));
    }
}

