/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.model.Person;
import org.openurp.base.service.StudentService;
import org.openurp.base.std.model.Graduate;
import org.openurp.base.std.model.Student;
import org.openurp.base.std.model.StudentState;
import org.openurp.code.edu.model.StudentStatus;

public class StudentServiceImpl
extends BaseServiceImpl
implements StudentService {
    @Override
    public Student getStudent(Long studentId) {
        return (Student)this.entityDao.get(Student.class, (Serializable)studentId);
    }

    @Override
    public Student getStudent(Integer projectId, String code) {
        List list = this.entityDao.search((QueryBuilder)OqlBuilder.from(Student.class, (String)"s").where("s.project.id=:projectId and s.code = :code", (Object)projectId, (Object)code));
        if (list.isEmpty()) {
            return null;
        }
        return (Student)list.get(0);
    }

    @Override
    public StudentState getJournal(Student student) {
        return this.getJournal(student, new Date());
    }

    @Override
    public StudentState getJournal(Student student, Date date) {
        OqlBuilder builder = OqlBuilder.from(StudentState.class, (String)"stdJournal").where("stdJournal.std = :std and stdJournal.beginOn<=:now and (stdJournal.endOn is null or stdJournal.endOn>=:now)", (Object)student, (Object)date).orderBy("stdJournal.id desc");
        List rs = this.entityDao.search((QueryBuilder)builder);
        if (rs.isEmpty()) {
            builder = OqlBuilder.from(StudentState.class, (String)"stdJournal").where("stdJournal.std = :std and stdJournal.beginOn > :now", (Object)student, (Object)new java.sql.Date(System.currentTimeMillis())).orderBy("stdJournal.id");
            rs = this.entityDao.search((QueryBuilder)builder);
        }
        return rs.isEmpty() ? null : (StudentState)((Object)rs.get(0));
    }

    @Override
    public void endJournal(Student std, java.sql.Date endOn, StudentStatus graduated) {
        StudentStatus inschool = (StudentStatus)this.entityDao.get(StudentStatus.class, (Serializable)Integer.valueOf(1));
        StudentState graduateState = null;
        for (StudentState ss : std.getStates()) {
            if ((!ss.getStatus().equals((Object)graduated) || ss.getBeginOn().equals(std.getBeginOn())) && !ss.getBeginOn().equals(endOn)) continue;
            graduateState = ss;
            break;
        }
        if (null == graduateState) {
            StudentState state = std.getState();
            java.sql.Date previousDay = java.sql.Date.valueOf(endOn.toLocalDate().plusDays(-1L));
            state.setEndOn(previousDay);
            if (state.getStatus().equals((Object)graduated)) {
                state.setStatus(inschool);
                state.setInschool(true);
            }
            this.entityDao.saveOrUpdate(new Object[]{state});
            StudentState newState = new StudentState();
            newState.setStd(state.getStd());
            newState.setGrade(state.getGrade());
            newState.setDepartment(state.getDepartment());
            newState.setCampus(state.getCampus());
            newState.setMajor(state.getMajor());
            newState.setDirection(state.getDirection());
            newState.setSquad(state.getSquad());
            graduateState = newState;
        }
        graduateState.setInschool(false);
        graduateState.setStatus(graduated);
        graduateState.setBeginOn(endOn);
        graduateState.setEndOn(graduateState.getBeginOn());
        std.setState(graduateState);
        std.setEndOn(endOn);
        this.entityDao.saveOrUpdate(new Object[]{graduateState, std});
    }

    @Override
    public boolean isInschool(Student student) {
        return this.isInschool(student, new Date());
    }

    @Override
    public boolean isInschool(Student student, Date date) {
        StudentState journal = this.getJournal(student, date);
        return journal == null ? false : journal.isInschool();
    }

    @Override
    public boolean isActive(Student student) {
        return this.isActive(student, new Date());
    }

    @Override
    public boolean isActive(Student student, Date date) {
        return student.isRegisted() && student.getBeginOn().before(date) && student.getEndOn().after(date);
    }

    @Override
    public StudentStatus getStdStatus(Student student) {
        return this.getStdStatus(student, new Date());
    }

    @Override
    public StudentStatus getStdStatus(Student student, Date date) {
        StudentState journal = this.getJournal(student, date);
        if (journal != null) {
            return journal.getStatus();
        }
        return null;
    }

    public Student getStudentByCode(String code) {
        List list = this.entityDao.get(Student.class, "code", new Object[]{code});
        if (list.isEmpty()) {
            return null;
        }
        return (Student)list.get(0);
    }

    @Override
    public Student getMajorProjectStudent(Person stdPerson) {
        OqlBuilder query = OqlBuilder.from(Student.class, (String)"std");
        query.where("std.person = :stdPerson", (Object)stdPerson).where("std.project.minor = false");
        return (Student)this.entityDao.uniqueResult((QueryBuilder)query);
    }

    @Override
    public Student getMinorProjectStudent(Person stdPerson) {
        OqlBuilder query = OqlBuilder.from(Student.class, (String)"std");
        query.where("std.person = :stdPerson", (Object)stdPerson).where("std.project.minor = true");
        return (Student)this.entityDao.uniqueResult((QueryBuilder)query);
    }

    @Override
    public Graduate getGraduate(Student std) {
        List graduations = this.entityDao.get(Graduate.class, "std", new Object[]{std});
        return CollectionUtils.isEmpty((Collection)graduations) ? null : (Graduate)graduations.get(0);
    }
}

