/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.service.TeacherService;

public class TeacherServiceImpl
extends BaseServiceImpl
implements TeacherService {
    @Override
    public Teacher getTeacher(String code) {
        if (Strings.isBlank((CharSequence)code)) {
            return null;
        }
        Iterator it = this.entityDao.get(Teacher.class, "code", new Object[]{code}).iterator();
        return it.hasNext() ? (Teacher)((Object)it.next()) : null;
    }

    @Override
    public List<Object[]> getTeacherNamesByDepart(Integer departmentId) {
        if (null == departmentId) {
            return CollectUtils.newArrayList((int)0);
        }
        OqlBuilder builder = OqlBuilder.from((String)(Teacher.class.getName() + " teacher"));
        builder.where("teacher.department.id=:departmentId", (Object)departmentId);
        builder.select("teacher.id,teacher.name");
        return this.entityDao.search((QueryBuilder)builder);
    }

    @Override
    public Teacher getTeacherById(Long id) {
        return (Teacher)this.entityDao.get(Teacher.class, (Serializable)id);
    }

    @Override
    public Teacher getTeacherByNO(String teacherNO) {
        if (Strings.isEmpty((CharSequence)teacherNO)) {
            return null;
        }
        List teachers = this.entityDao.get(Teacher.class, "code", new Object[]{teacherNO});
        if (teachers.isEmpty()) {
            return null;
        }
        return (Teacher)((Object)teachers.get(0));
    }

    @Override
    public List<Teacher> getTeachersByDepartment(String departIds) {
        if (Strings.isEmpty((CharSequence)departIds)) {
            return Collections.emptyList();
        }
        return this.getTeachersByDepartment(Strings.transformToLong((String[])Strings.split((String)departIds)));
    }

    @Override
    public List<Teacher> getTeachersByDepartment(Long[] departIds) {
        if (null == departIds || departIds.length < 1) {
            return Collections.emptyList();
        }
        return this.entityDao.get(Teacher.class, "department.id", (Object[])departIds);
    }

    @Override
    public List<Teacher> getTeachersById(Long[] teacherIds) {
        if (null == teacherIds || teacherIds.length < 1) {
            return Collections.emptyList();
        }
        return this.entityDao.get(Teacher.class, "id", (Object[])teacherIds);
    }

    @Override
    public List<Teacher> getTeachersById(Collection teacherIds) {
        if (!teacherIds.isEmpty()) {
            return this.entityDao.get(Teacher.class, "id", teacherIds);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Teacher> getTeachersByNO(String[] teacherNOs) {
        if (null == teacherNOs || teacherNOs.length < 1) {
            return Collections.emptyList();
        }
        return this.entityDao.get(Teacher.class, "code", (Object[])teacherNOs);
    }
}

