/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.model;

import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.openurp.edu.clazz.model.ClazzRestriction;
import org.openurp.edu.clazz.model.ClazzRestrictionMeta;

@Entity(name="org.openurp.edu.clazz.model.ClazzRestrictionItem")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
public class ClazzRestrictionItem
extends LongIdObject
implements Cloneable {
    private static final long serialVersionUID = -6697398004696236934L;
    @NotNull
    @Type(type="org.beangle.orm.hibernate.udt.IDEnumType")
    private ClazzRestrictionMeta meta;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ClazzRestriction restriction;
    private boolean included;
    @NotNull
    private String contents;

    public ClazzRestrictionItem() {
    }

    public ClazzRestrictionItem(ClazzRestrictionMeta meta, String contents, boolean included) {
        this.meta = meta;
        this.contents = contents;
        this.included = included;
    }

    public ClazzRestrictionMeta getMeta() {
        return this.meta;
    }

    public void setMeta(ClazzRestrictionMeta meta) {
        this.meta = meta;
    }

    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public ClazzRestriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(ClazzRestriction restriction) {
        this.restriction = restriction;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public Object clone() {
        try {
            ClazzRestrictionItem clone = (ClazzRestrictionItem)super.clone();
            clone.setId(null);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public String getContentForHql() {
        if (null != this.contents && null != this.meta && ClazzRestrictionMeta.Grade.equals((Object)this.meta)) {
            this.contents = "'" + this.contents + "'";
        }
        return this.contents;
    }

    public String toString() {
        return this.contents;
    }
}

