/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.service.internal;

import org.beangle.commons.entity.Entity;
import org.beangle.commons.lang.Strings;
import org.openurp.base.edu.model.Direction;
import org.openurp.base.edu.model.Major;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.Squad;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.person.model.Gender;
import org.openurp.code.std.model.StdType;
import org.openurp.edu.clazz.model.ClazzRestriction;
import org.openurp.edu.clazz.model.ClazzRestrictionItem;
import org.openurp.edu.clazz.model.ClazzRestrictionMeta;
import org.openurp.edu.clazz.service.RestrictionBuilder;
import org.openurp.edu.clazz.service.internal.DefaultTeachClassNameStrategy;

public class DefaultRestrictionBuilder
implements RestrictionBuilder {
    ClazzRestriction group = new ClazzRestriction();
    DefaultTeachClassNameStrategy strategy = new DefaultTeachClassNameStrategy();

    public DefaultRestrictionBuilder() {
    }

    public DefaultRestrictionBuilder(ClazzRestriction group) {
        this.group = group;
    }

    @Override
    public RestrictionBuilder inGrades(String ... grades) {
        if (grades.length > 0 && grades[0] != null) {
            ClazzRestrictionItem item = this.getOrCreateItem(ClazzRestrictionMeta.Grade);
            this.addValues(item, true, grades);
        }
        return this;
    }

    @Override
    public RestrictionBuilder notInGrades(String ... grades) {
        ClazzRestrictionItem item = this.getOrCreateItem(ClazzRestrictionMeta.Grade);
        this.addValues(item, false, grades);
        return this;
    }

    @Override
    public <T extends Entity<?>> RestrictionBuilder in(T ... entities) {
        if (entities.length > 0 && entities[0] != null) {
            T first = entities[0];
            ClazzRestrictionItem item = this.getItem(first);
            this.addValues(item, true, this.getIds((Entity<?>[])entities));
        }
        if (entities.length > 0 && entities[0] instanceof Squad) {
            this.clear(ClazzRestrictionMeta.Grade);
            this.clear(ClazzRestrictionMeta.StdType);
            this.clear(ClazzRestrictionMeta.Department);
            this.clear(ClazzRestrictionMeta.Major);
            this.clear(ClazzRestrictionMeta.Direction);
            this.clear(ClazzRestrictionMeta.Level);
        }
        return this;
    }

    @Override
    public <T extends Entity<?>> RestrictionBuilder notIn(T ... entities) {
        if (entities.length >= 0 && entities[0] != null) {
            T first = entities[0];
            ClazzRestrictionItem item = this.getItem(first);
            this.addValues(item, false, this.getIds((Entity<?>[])entities));
        }
        return this;
    }

    @Override
    public RestrictionBuilder clear(ClazzRestrictionMeta meta) {
        ClazzRestrictionItem removed = null;
        for (ClazzRestrictionItem item : this.group.getItems()) {
            if (!item.getMeta().equals((Object)meta)) continue;
            removed = item;
        }
        if (null != removed) {
            this.group.getItems().remove(removed);
        }
        return this;
    }

    @Override
    public ClazzRestriction build() {
        return this.group;
    }

    private String[] getIds(Entity<?> ... entities) {
        String[] ids = new String[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            if (entities[i] == null) continue;
            ids[i] = String.valueOf(entities[i].getId());
        }
        return ids;
    }

    private void addValues(ClazzRestrictionItem item, boolean contain, String ... values) {
        Object old = item.getContents();
        old = ((String)old).length() > 0 ? Strings.concat((String[])new String[]{old, ",", Strings.join((String[])values, (String)",")}) : Strings.join((String[])values, (String)",");
        if (-1 != ((String)old).indexOf(44)) {
            if (!((String)old).startsWith(",")) {
                old = "," + (String)old;
            }
            if (!((String)old).endsWith(",")) {
                old = (String)old + ",";
            }
        }
        item.setContents((String)old);
        item.setIncluded(contain);
    }

    private ClazzRestrictionItem getOrCreateItem(ClazzRestrictionMeta meta) {
        for (ClazzRestrictionItem item : this.group.getItems()) {
            if (!item.getMeta().equals((Object)meta)) continue;
            return item;
        }
        ClazzRestrictionItem item = new ClazzRestrictionItem();
        item.setMeta(meta);
        item.setIncluded(true);
        item.setContents("");
        item.setRestriction(this.group);
        this.group.getItems().add(item);
        return item;
    }

    private <T> ClazzRestrictionItem getItem(T first) {
        ClazzRestrictionItem item = null;
        if (first instanceof Gender) {
            item = this.getOrCreateItem(ClazzRestrictionMeta.Gender);
        } else if (first instanceof StdType) {
            item = this.getOrCreateItem(ClazzRestrictionMeta.StdType);
        } else if (first instanceof Department) {
            item = this.getOrCreateItem(ClazzRestrictionMeta.Department);
        } else if (first instanceof Major) {
            item = this.getOrCreateItem(ClazzRestrictionMeta.Major);
        } else if (first instanceof Direction) {
            item = this.getOrCreateItem(ClazzRestrictionMeta.Direction);
        } else if (first instanceof Squad) {
            item = this.getOrCreateItem(ClazzRestrictionMeta.Squad);
        } else if (first instanceof EducationLevel) {
            item = this.getOrCreateItem(ClazzRestrictionMeta.Level);
        } else {
            throw new RuntimeException("no support limit meta class " + first.getClass().getName());
        }
        return item;
    }
}

