/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service;

import java.text.NumberFormat;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Numbers;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.script.ExpressionEvaluator;
import org.openurp.edu.grade.config.GradeRateConfig;
import org.openurp.edu.grade.config.GradeRateItem;

public class ScoreConverter {
    private GradeRateConfig config;
    private ExpressionEvaluator expressionEvaluator;
    private Map<String, Float> defaultScoreMap;

    public ScoreConverter(GradeRateConfig config, ExpressionEvaluator expressionEvaluator) {
        this.config = config;
        this.expressionEvaluator = expressionEvaluator;
        this.defaultScoreMap = CollectUtils.newHashMap();
        if (null != config) {
            for (GradeRateItem item : config.getItems()) {
                this.defaultScoreMap.put(item.getGrade(), item.getDefaultScore());
            }
        }
    }

    public String convert(Float score) {
        if (null == score) {
            return "";
        }
        if (null == this.config) {
            return NumberFormat.getInstance().format(score.floatValue());
        }
        return this.config.convert(score);
    }

    public boolean isPassed(Float score) {
        if (null == this.config || null == score) {
            return false;
        }
        return Float.compare(score.floatValue(), this.config.getPassScore()) >= 0;
    }

    public Float convert(String score) {
        if (Strings.isBlank((CharSequence)score)) {
            return null;
        }
        if (null == this.config || this.config.getItems().size() == 0) {
            if (Numbers.isDigits((String)score)) {
                return new Float(Numbers.toFloat((String)score));
            }
            return null;
        }
        Float newScore = this.defaultScoreMap.get(score);
        if (null != newScore) {
            return newScore;
        }
        if (Numbers.isDigits((String)score)) {
            return new Float(Numbers.toFloat((String)score));
        }
        return null;
    }

    public Float calcGp(Float score) {
        if (null == score || score.floatValue() <= 0.0f) {
            return new Float(0.0f);
        }
        for (GradeRateItem gradeRateItem : this.config.getItems()) {
            if (!gradeRateItem.inScope(score)) continue;
            if (Strings.isNotEmpty((CharSequence)gradeRateItem.getGpExp())) {
                Map data = CollectUtils.newHashMap();
                data.put("score", score);
                return (Float)this.expressionEvaluator.eval(gradeRateItem.getGpExp(), (Object)data, Float.class);
            }
            return null;
        }
        return new Float(0.0f);
    }
}

