/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service;

import org.beangle.commons.dao.EntityDao;
import org.beangle.orm.hibernate.internal.SessionHolder;
import org.beangle.orm.hibernate.internal.SessionUtils;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractJob {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SessionFactory sessionFactory;
    protected EntityDao entityDao;

    private Session getSession() {
        Session session = this.sessionFactory.openSession();
        session.setFlushMode(FlushMode.MANUAL);
        return session;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public final void execute() {
        Session session = this.getSession();
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder(session));
        try {
            this.doExecute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            this.logger.debug("Closing single Hibernate Session in OpenSessionInViewInterceptor");
            SessionUtils.closeSession((Session)sessionHolder.getSession());
        }
    }

    protected abstract void doExecute();
}

