/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.dao.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Numbers;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.Throwables;
import org.beangle.commons.lang.reflect.Reflections;
import org.beangle.orm.hibernate.HibernateEntityDao;
import org.openurp.base.edu.model.Course;
import org.openurp.base.time.Terms;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.edu.program.model.AbstractCourseGroup;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.ExecutiveCourseGroup;
import org.openurp.edu.program.model.ExecutivePlanCourse;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.plan.dao.PlanCommonDao;
import org.openurp.edu.program.plan.dao.PlanCourseGroupCommonDao;
import org.openurp.edu.program.plan.util.PlanTermCreditTool;
import org.openurp.edu.program.plan.util.ProgramHibernateClassGetter;
import org.openurp.edu.program.utils.PlanUtils;

public class PlanCourseGroupCommonDaoHibernate
extends HibernateEntityDao
implements PlanCourseGroupCommonDao {
    private PlanCommonDao planCommonDao;

    @Override
    public void saveOrUpdateCourseGroup(CourseGroup group) {
        this.statGroupCredits(group);
        this.updateGroupTreeCredits(this.getTopGroup(group));
        group.getPlan().setCredits(this.planCommonDao.statPlanCredits(group.getPlan()));
        this.saveOrUpdate(new Object[]{group.getPlan()});
    }

    @Override
    public void updateCourseGroupParent(CourseGroup group, CourseGroup newParent, CoursePlan plan) {
    }

    @Override
    public void addCourseGroupToPlan(CourseGroup group, CoursePlan plan) {
        group.setParent(null);
        PlanCourseGroupCommonDaoHibernate.addGroup(plan, group);
        this.saveOrUpdate(new Object[]{group});
        this.saveOrUpdate(new Object[]{plan});
        PlanCourseGroupCommonDaoHibernate.reSortCourseGroups(plan);
        this.updateGroupTreeCredits(this.getTopGroup(group));
        plan.setCredits(this.planCommonDao.statPlanCredits(plan));
        this.saveOrUpdate(new Object[]{plan});
    }

    @Override
    public void addCourseGroupToPlan(CourseGroup group, CourseGroup parent, CoursePlan plan) {
        group.setParent(parent);
        if (parent != null) {
            parent.addChildGroup(group);
            this.saveOrUpdate(new Object[]{parent});
        }
        PlanCourseGroupCommonDaoHibernate.addGroup(plan, group);
        this.saveOrUpdate(new Object[]{group});
        this.saveOrUpdate(new Object[]{plan});
        PlanCourseGroupCommonDaoHibernate.reSortCourseGroups(plan);
        this.updateGroupTreeCredits(this.getTopGroup(group));
        plan.setCredits(this.planCommonDao.statPlanCredits(plan));
        this.saveOrUpdate(new Object[]{plan});
    }

    @Override
    public void removeCourseGroup(CourseGroup group) {
        CoursePlan plan = group.getPlan();
        CourseGroup parent = group.getParent();
        CourseGroup topGroup = this.getTopGroup(group);
        if (group.getChildren() != null && group.getChildren().size() > 0) {
            ArrayList<CourseGroup> t_children = new ArrayList<CourseGroup>(group.getChildren());
            for (CourseGroup child : t_children) {
                this.removeCourseGroup(child);
            }
        }
        if (parent != null) {
            parent.getChildren().remove(group);
            group.setParent(null);
        }
        plan.getGroups().remove(group);
        PlanCourseGroupCommonDaoHibernate.reSortCourseGroups(plan);
        if (parent == null) {
            this.statGroupCredits(group);
            plan.setCredits(this.planCommonDao.statPlanCredits(plan));
        } else {
            this.updateGroupTreeCredits(topGroup);
            plan.setCredits(this.planCommonDao.statPlanCredits(plan));
        }
        this.saveOrUpdate(new Object[]{plan});
    }

    @Override
    public CourseGroup getTopGroup(CourseGroup group) {
        if (group.getParent() != null) {
            return this.getTopGroup(group.getParent());
        }
        return group;
    }

    private void statGroupCredits(CourseGroup group) {
        if (group.isAutoAddup() && (CollectUtils.isNotEmpty(group.getChildren()) || CollectUtils.isNotEmpty(group.getPlanCourses()))) {
            float credits = 0.0f;
            int creditHours = 0;
            Object termCredits = Strings.repeat((String)",0", (int)group.getPlan().getProgram().getEndTerm()) + ",";
            for (CourseGroup child : group.getChildren()) {
                credits += child.getCredits();
                creditHours += child.getCreditHours();
                termCredits = PlanTermCreditTool.mergeTermCredits((String)termCredits, child.getTermCredits());
            }
            for (PlanCourse pcourse : group.getPlanCourses()) {
                creditHours += pcourse.getCourse().getCreditHours();
                credits += pcourse.getCourse().getCredits(group.getPlan().getProgram().getLevel());
                termCredits = this.addCreditsInTerms((String)termCredits, pcourse);
            }
            String[] carray = Strings.split((String)termCredits);
            Object t = ",";
            for (int i = 0; i < carray.length; ++i) {
                if (!(Numbers.toFloat((String)carray[i]) > 0.0f)) continue;
                t = (String)t + (i + 1) + ",";
            }
            Terms terms = new Terms((String)t);
            group.setTermCredits((String)termCredits);
            group.setTerms(terms);
            group.setCredits(credits);
            group.setCreditHours(creditHours);
            this.saveOrUpdate(new Object[]{group});
        }
    }

    public void updateParentGroupCredits(CourseGroup group) {
        CourseGroup parent = group.getParent();
        if (null != parent) {
            this.statGroupCredits(parent);
            this.updateParentGroupCredits(parent);
        }
    }

    @Override
    public void updateGroupTreeCredits(CourseGroup group) {
        for (CourseGroup child : group.getChildren()) {
            this.updateGroupTreeCredits(child);
        }
        this.statGroupCredits(group);
    }

    private String addCreditsInTerms(String termCredits, PlanCourse planCourse) {
        String[] credits = termCredits.replaceAll("^,", "").replaceAll(",$", "").split(",");
        if (PlanUtils.isUnplannedTerm(planCourse.getTerms())) {
            return termCredits;
        }
        String[] terms = planCourse.getTerms().toString().replaceAll("^,", "").replaceAll(",$", "").split(",");
        EducationLevel level = planCourse.getGroup().getPlan().getProgram().getLevel();
        for (int i = 0; i < terms.length; ++i) {
            try {
                float credit;
                int term = Integer.valueOf(terms[i]);
                if (term >= credits.length) {
                    credit = Float.valueOf(credits[credits.length - 1]).floatValue() + planCourse.getCourse().getCredits(level);
                    credits[credits.length - 1] = String.valueOf(credit).replaceAll(".0$", "");
                    continue;
                }
                credit = Float.valueOf(credits[term - 1]).floatValue() + planCourse.getCourse().getCredits(level);
                credits[term - 1] = String.valueOf(credit).replaceAll(".0$", "");
                continue;
            }
            catch (NumberFormatException e) {
                String term = terms[i];
                credits[0] = term.replaceAll(".0$", "");
            }
        }
        return "," + Strings.join((String[])credits, (String)",") + ",";
    }

    @Override
    public void updateCourseGroupMoveDown(CourseGroup courseGroup) {
        CoursePlan plan = courseGroup.getPlan();
        CourseGroup parent = courseGroup.getParent();
        if (null == parent) {
            int meInTopIndex = plan.getTopCourseGroups().indexOf(courseGroup);
            if (meInTopIndex == plan.getTopCourseGroups().size() - 1) {
                throw new RuntimeException("CourseGroup cannot be moved down, because it's already the last one");
            }
            ExecutiveCourseGroup meHindGroup = (ExecutiveCourseGroup)plan.getTopCourseGroups().get(meInTopIndex + 1);
            int meInPreOrderIndex = plan.getGroups().indexOf(courseGroup);
            int meHindGroupInPreOrderIndex = plan.getGroups().indexOf(meHindGroup);
            this.swap(plan.getGroups(), meInPreOrderIndex, meHindGroupInPreOrderIndex);
        } else {
            int meIndex = parent.getChildren().indexOf(courseGroup);
            if (meIndex == parent.getChildren().size() - 1) {
                throw new RuntimeException("CourseGroup cannot be moved down, because it's already the last one in it's parent CourseGroup");
            }
            this.swap(parent.getChildren(), meIndex, meIndex + 1);
            this.saveOrUpdate(new Object[]{parent});
        }
        PlanCourseGroupCommonDaoHibernate.reSortCourseGroups(plan);
        this.saveOrUpdate(new Object[]{plan});
    }

    protected static List<CourseGroup> getPreOrderTraversalChildren(CourseGroup group) {
        List result = CollectUtils.newArrayList();
        result.add(group);
        for (CourseGroup child : group.getChildren()) {
            result.addAll(PlanCourseGroupCommonDaoHibernate.getPreOrderTraversalChildren(child));
        }
        return result;
    }

    protected static void reSortCourseGroups(CoursePlan plan) {
        ArrayList<CourseGroup> tGroups = new ArrayList<CourseGroup>();
        for (CourseGroup courseGroup : plan.getTopCourseGroups()) {
            tGroups.addAll(PlanCourseGroupCommonDaoHibernate.getPreOrderTraversalChildren(courseGroup));
        }
        plan.getGroups().clear();
        plan.getGroups().addAll(tGroups);
    }

    protected static void addGroup(CoursePlan plan, CourseGroup group) {
        if (null == plan.getGroups()) {
            plan.setGroups(new ArrayList<CourseGroup>());
        }
        plan.getGroups().add(group);
        group.updateCoursePlan(plan);
    }

    @Override
    public void updateCourseGroupMoveUp(CourseGroup courseGroup) {
        CoursePlan plan = courseGroup.getPlan();
        CourseGroup parent = courseGroup.getParent();
        if (null == parent) {
            int meInTopIndex = plan.getTopCourseGroups().indexOf(courseGroup);
            if (meInTopIndex == 0) {
                throw new RuntimeException("CourseGroup cannot be moved up, because it's already the first one");
            }
            ExecutiveCourseGroup meFrontGroup = (ExecutiveCourseGroup)plan.getTopCourseGroups().get(meInTopIndex - 1);
            int meInPreOrderIndex = plan.getGroups().indexOf(courseGroup);
            int meFrontGroupInPreOrderIndex = plan.getGroups().indexOf(meFrontGroup);
            this.swap(plan.getGroups(), meInPreOrderIndex, meFrontGroupInPreOrderIndex);
        } else {
            int meIndex = parent.getChildren().indexOf(courseGroup);
            if (meIndex == 0) {
                throw new RuntimeException("CourseGroup cannot be moved up, because it's already the first one in it's parent CourseGroup");
            }
            this.swap(parent.getChildren(), meIndex, meIndex - 1);
            this.saveOrUpdate(new Object[]{parent});
        }
        PlanCourseGroupCommonDaoHibernate.reSortCourseGroups(plan);
        this.saveOrUpdate(new Object[]{plan});
    }

    private void swap(List anyList, int index1, int index2) {
        Object o1 = anyList.get(index1);
        Object o2 = anyList.get(index2);
        anyList.set(index2, o1);
        anyList.set(index1, o2);
    }

    @Override
    public ExecutiveCourseGroup getCourseGroupByCourseType(CourseGroup planGroup, Long planId, Integer courseTypeId) {
        OqlBuilder oql = OqlBuilder.from(ProgramHibernateClassGetter.hibernateClass(planGroup), (String)"cgroup");
        oql.where("cgroup.courseType.id = :typeId", (Object)courseTypeId);
        oql.where("cgroup.plan.id = :planId", (Object)planId);
        List l = this.search((QueryBuilder)oql);
        if (l != null && l.size() > 0) {
            return (ExecutiveCourseGroup)l.get(0);
        }
        return null;
    }

    @Override
    public List<Course> extractCourseInCourseGroup(ExecutiveCourseGroup group, String terms) {
        HashSet<Course> courses = new HashSet<Course>();
        Integer[] findTerm = Strings.splitNumSeq((String)terms);
        if (null == findTerm || findTerm.length == 0) {
            return Collections.EMPTY_LIST;
        }
        for (int i = 0; i < findTerm.length; ++i) {
            for (PlanCourse planCourse : PlanUtils.getPlanCourses(group, (int)findTerm[i])) {
                courses.add(planCourse.getCourse());
            }
        }
        return new ArrayList<Course>(courses);
    }

    @Override
    public List<ExecutivePlanCourse> extractPlanCourseInCourseGroup(ExecutiveCourseGroup group, Set<String> terms) {
        Set result = CollectUtils.newHashSet();
        for (String term : terms) {
            result.addAll(PlanUtils.getPlanCourses(group, (int)Integer.valueOf(term)));
        }
        return new ArrayList<ExecutivePlanCourse>(result);
    }

    @Override
    public CourseGroup copyCourseGroup(CourseGroup sourceCourseGroup, CourseGroup parentAttachTo, CoursePlan planAttachTo, Class<?> groupClazz, Class<?> pcClazz) {
        CourseGroup cloneGroup = (CourseGroup)Reflections.newInstance(groupClazz);
        this.commonSetting(cloneGroup, sourceCourseGroup);
        this.normalizeTerms(cloneGroup, planAttachTo.getProgram().getEndTerm());
        if (parentAttachTo == null) {
            this.addCourseGroupToPlan(cloneGroup, planAttachTo);
        } else {
            if (!((Long)parentAttachTo.getPlan().getId()).equals(planAttachTo.getId())) {
                throw new RuntimeException("parentAttachTo.coursePlan must be same with planAttachTo");
            }
            this.addCourseGroupToPlan(cloneGroup, parentAttachTo, planAttachTo);
        }
        this.saveOrUpdate(new Object[]{cloneGroup});
        this.copyPlanCourses(sourceCourseGroup.getPlanCourses(), cloneGroup, pcClazz);
        for (CourseGroup child : sourceCourseGroup.getChildren()) {
            this.copyCourseGroup(child, cloneGroup, planAttachTo, groupClazz, pcClazz);
        }
        this.saveOrUpdate(new Object[]{cloneGroup});
        return cloneGroup;
    }

    private void normalizeTerms(CourseGroup group, Integer newTermsCount) {
        Float[] creditsTerms = PlanTermCreditTool.transformToFloat(group.getTermCredits());
        int oldTermsCount = creditsTerms.length;
        String newCreditPerTerms = PlanTermCreditTool.buildCourseGroupTermCredits(creditsTerms, oldTermsCount, newTermsCount);
        group.setTermCredits(newCreditPerTerms);
    }

    private void commonSetting(CourseGroup newGroup, CourseGroup src) {
        newGroup.setSubCount(src.getSubCount());
        newGroup.setCreditHours(src.getCreditHours());
        newGroup.setCourseType(src.getCourseType());
        newGroup.setCredits(src.getCredits());
        newGroup.setTermCredits(src.getTermCredits());
        newGroup.setRemark(src.getRemark());
        newGroup.setIndexno(src.getIndexno());
        if (newGroup instanceof AbstractCourseGroup) {
            AbstractCourseGroup acg = (AbstractCourseGroup)newGroup;
            acg.setRank(((AbstractCourseGroup)src).getRank());
            acg.setGivenName(((AbstractCourseGroup)src).getGivenName());
        }
    }

    public List<? extends PlanCourse> copyPlanCourses(List<? extends PlanCourse> sourcePlanCourses, CourseGroup courseGroupAttachTo, Class<?> pcClazz) {
        ArrayList<PlanCourse> res = new ArrayList<PlanCourse>();
        for (PlanCourse planCourse : sourcePlanCourses) {
            res.add(this.copyPlanCourse(planCourse, courseGroupAttachTo, pcClazz));
        }
        return res;
    }

    @Override
    public PlanCourse copyPlanCourse(PlanCourse sourcePlanCourse, CourseGroup courseGroupAttachTo, Class<?> pcClazz) {
        PlanCourse clonePlanCourse = (PlanCourse)Reflections.newInstance(pcClazz);
        this.commonSetting(clonePlanCourse, sourcePlanCourse);
        courseGroupAttachTo.addPlanCourse(clonePlanCourse);
        this.normalizeTerm(clonePlanCourse, sourcePlanCourse.getGroup().getPlan().getProgram().getTermsCount(), courseGroupAttachTo.getPlan().getProgram().getTermsCount());
        this.saveOrUpdate(new Object[]{courseGroupAttachTo});
        return clonePlanCourse;
    }

    private void normalizeTerm(PlanCourse planCourse, int oldTermsCount, int newTermsCount) {
        planCourse.setTerms(PlanTermCreditTool.buildPlanCourseTerms(planCourse.getTerms(), oldTermsCount, newTermsCount));
    }

    private void commonSetting(PlanCourse copy, PlanCourse sourcePlanCourse) {
        try {
            PropertyUtils.copyProperties((Object)copy, (Object)sourcePlanCourse);
            copy.setGroup(null);
            copy.setId(null);
        }
        catch (Exception e) {
            throw new RuntimeException("error in clone ExecutivePlanCourse:" + Throwables.getStackTrace((Throwable)e));
        }
    }

    public void setPlanCommonDao(PlanCommonDao planCommonDao) {
        this.planCommonDao = planCommonDao;
    }
}

