/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.service.impl;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.model.BaseInfo;
import org.openurp.base.model.School;
import org.openurp.base.service.BaseInfoService;

public class BaseInfoServiceImpl
extends BaseServiceImpl
implements BaseInfoService {
    @Override
    public List getBaseInfos(Class clazz, School school2) {
        if (BaseInfo.class.isAssignableFrom(clazz) || this.likeBaseInfo(clazz)) {
            OqlBuilder builder = OqlBuilder.from((Class)clazz, (String)"baseInfo").where("baseInfo.beginOn <= :now and (baseInfo.endOn is null or baseInfo.endOn >= :now)", (Object)new Date()).where("baseInfo.school=:school", (Object)school2).orderBy("baseInfo.code");
            builder.cacheable(true);
            return this.entityDao.search((QueryBuilder)builder);
        }
        throw new RuntimeException(clazz.getName() + " is not a baseInfo ");
    }

    private boolean likeBaseInfo(Class clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        boolean hasBeginOn = false;
        boolean hasEndOn = false;
        boolean hasCode = false;
        for (Method method : methods) {
            if ("getBeginOn".equals(method.getName())) {
                hasBeginOn = true;
                continue;
            }
            if ("getEndOn".equals(method.getName())) {
                hasEndOn = true;
                continue;
            }
            if (!"getCode".equals(method.getName())) continue;
            hasCode = true;
        }
        return hasBeginOn && hasCode && hasEndOn;
    }

    @Override
    public BaseInfo getBaseInfo(Class clazz, Integer id) {
        OqlBuilder query = OqlBuilder.from((Class)clazz, (String)"info");
        query.where("info.id=:infoId", (Object)id);
        List rs = this.entityDao.search((QueryBuilder)query);
        if (!rs.isEmpty()) {
            return (BaseInfo)rs.get(0);
        }
        return null;
    }
}

