/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.util;

import org.beangle.commons.entity.Component;

public class FloatRange
implements Component {
    private float min;
    private boolean minInclusive = true;
    private float max;
    private boolean maxInclusive = true;

    public FloatRange() {
        this.min = 0.0f;
        this.max = 0.0f;
    }

    public FloatRange(float number) {
        if (Float.isNaN(number)) {
            throw new IllegalArgumentException("The number must not be NaN");
        }
    }

    public FloatRange(float min, float max) {
        if (Float.isNaN(min) || Float.isNaN(max)) {
            throw new IllegalArgumentException("The numbers must not be NaN");
        }
        if (max < min) {
            this.min = max;
            this.max = min;
        } else {
            this.min = min;
            this.max = max;
        }
    }

    public FloatRange(float min, boolean minInclusive, float max, boolean maxInclusive) {
        this(min, max);
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    public void minInclusive() {
        this.minInclusive = true;
    }

    public void minExclusive() {
        this.minInclusive = false;
    }

    public void inclusive() {
        this.minInclusive = true;
        this.maxInclusive = true;
    }

    public void exclusive() {
        this.minInclusive = false;
        this.maxInclusive = false;
    }

    public void maxInclusive() {
        this.maxInclusive = true;
    }

    public void maxExclusive() {
        this.maxInclusive = false;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public boolean isMinInclusive() {
        return this.minInclusive;
    }

    public void setMinInclusive(boolean minInclusive) {
        this.minInclusive = minInclusive;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public boolean isMaxInclusive() {
        return this.maxInclusive;
    }

    public void setMaxInclusive(boolean maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public boolean containsFloat(float value) {
        boolean result = true;
        boolean bl = this.minInclusive ? this.min <= value && result : (result = this.min < value && result);
        result = this.maxInclusive ? value <= this.max && result : value < this.max && result;
        return result;
    }

    private boolean containsFloat(float value, NearType nearType) {
        if (nearType == NearType.EQUAL) {
            return this.containsFloat(value);
        }
        if (nearType == NearType.OVER) {
            if (this.min == value && this.max > value) {
                return true;
            }
            if (this.max == value) {
                return false;
            }
            return this.containsFloat(value);
        }
        if (this.min == value) {
            return false;
        }
        if (this.max == value && this.min < value) {
            return true;
        }
        return this.containsFloat(value);
    }

    public boolean containsRange(FloatRange range) {
        if (range == null) {
            return false;
        }
        if (this.equals(range)) {
            return true;
        }
        boolean result = true;
        if (!(this.min != this.max || this.minInclusive && this.maxInclusive)) {
            return false;
        }
        if (!(range.min != range.max || range.minInclusive && range.maxInclusive)) {
            return true;
        }
        if (!range.minInclusive) {
            result = result && this.containsFloat(range.min, NearType.OVER);
        } else {
            boolean bl = result = result && this.containsFloat(range.min);
        }
        result = !range.maxInclusive ? result && this.containsFloat(range.max, NearType.BELOW) : result && this.containsFloat(range.max);
        return result;
    }

    public boolean overlapsRange(FloatRange range) {
        if (range == null) {
            return false;
        }
        if (this.equals(range)) {
            return true;
        }
        boolean result = false;
        if (!(this.min != this.max || this.minInclusive && this.maxInclusive)) {
            return false;
        }
        if (!(range.min != range.max || range.minInclusive && range.maxInclusive)) {
            return false;
        }
        if (!this.minInclusive) {
            result = result || range.containsFloat(this.min, NearType.OVER);
        } else {
            boolean bl = result = result || range.containsFloat(this.min);
        }
        if (!this.maxInclusive) {
            result = result || range.containsFloat(this.max, NearType.BELOW);
        } else {
            boolean bl = result = result || range.containsFloat(this.max);
        }
        result = !range.minInclusive ? result || this.containsFloat(range.min, NearType.OVER) : result || this.containsFloat(range.min);
        return result;
    }

    public float getDistance() {
        return this.max - this.min;
    }

    private float minIn(float a, float b, float c, float d) {
        return Math.min(Math.min(Math.min(a, b), c), d);
    }

    private float maxIn(float a, float b, float c, float d) {
        return Math.max(Math.max(Math.max(a, b), c), d);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.max);
        result = 31 * result + (this.maxInclusive ? 1231 : 1237);
        result = 31 * result + Float.floatToIntBits(this.min);
        result = 31 * result + (this.minInclusive ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatRange other = (FloatRange)obj;
        if (Float.floatToIntBits(this.max) != Float.floatToIntBits(other.max)) {
            return false;
        }
        if (this.maxInclusive != other.maxInclusive) {
            return false;
        }
        if (Float.floatToIntBits(this.min) != Float.floatToIntBits(other.min)) {
            return false;
        }
        return this.minInclusive == other.minInclusive;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.minInclusive ? (char)'[' : '(').append(this.min).append(", ").append(this.max).append(this.maxInclusive ? (char)']' : ')');
        return sb.toString();
    }

    private static enum NearType {
        OVER,
        BELOW,
        EQUAL;

    }
}

