/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.service;

import org.beangle.commons.dao.query.builder.Condition;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.lang.Strings;
import org.openurp.base.edu.model.Direction;
import org.openurp.base.edu.model.Major;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.Squad;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.person.model.Gender;
import org.openurp.code.std.model.StdType;
import org.openurp.edu.clazz.model.ClazzRestrictionMeta;

public class CourseLimitUtils {
    public static <T extends Entity<?>> Condition build(T entity, String alias) {
        ClazzRestrictionMeta meta = null;
        if (entity instanceof Gender) {
            meta = ClazzRestrictionMeta.Gender;
        } else if (entity instanceof StdType) {
            meta = ClazzRestrictionMeta.StdType;
        } else if (entity instanceof Department) {
            meta = ClazzRestrictionMeta.Department;
        } else if (entity instanceof Major) {
            meta = ClazzRestrictionMeta.Major;
        } else if (entity instanceof Direction) {
            meta = ClazzRestrictionMeta.Direction;
        } else if (entity instanceof Squad) {
            meta = ClazzRestrictionMeta.Squad;
        } else if (entity instanceof EducationLevel) {
            meta = ClazzRestrictionMeta.Level;
        } else {
            throw new RuntimeException("not supported limit meta class " + entity.getClass().getName());
        }
        return CourseLimitUtils.build(meta, alias, entity.getId().toString());
    }

    public static Condition build(ClazzRestrictionMeta meta, String alias, String id) {
        String template = " alias.meta = :meta and (case when alias.included=true and locate(:values,','||alias.contents||',')>0 then 1 else 0 end) = 1 ";
        String paramName = "metaValue" + CourseLimitUtils.randomInt();
        String paramName2 = paramName + "s";
        template = Strings.replace((String)template, (String)"alias", (String)alias);
        template = Strings.replace((String)template, (String)"values", (String)paramName2);
        template = Strings.replace((String)template, (String)"value", (String)paramName);
        return new Condition(template).param((Object)meta).param((Object)id).param((Object)("," + id + ","));
    }

    private static String randomInt() {
        String d = String.valueOf(Math.random());
        d = Strings.replace((String)d, (String)".", (String)"");
        d = d.substring(0, 8);
        return d;
    }
}

