/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.app.model;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.entity.pojo.NumberIdTimeObject;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.ExamStatus;
import org.openurp.code.edu.model.GradeType;

@Entity(name="org.openurp.edu.grade.app.model.GradeModifyApply")
public class GradeModifyApply
extends NumberIdTimeObject<Long> {
    private static final long serialVersionUID = -4325413107423926231L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Student std;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Semester semester;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Course course;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private GradeType gradeType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamStatus examStatus;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamStatus examStatusBefore;
    private Float origScore;
    private String origScoreText;
    private Float score;
    private String scoreText;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private GradeModifyStatus status = GradeModifyStatus.NOT_AUDIT;
    private String applyReason;
    private String auditReason;
    @Size(max=50)
    private String applyer;
    @Size(max=50)
    private String auditer;
    @Size(max=50)
    private String finalAuditer;

    public GradeType getGradeType() {
        return this.gradeType;
    }

    public void setGradeType(GradeType gradeType) {
        this.gradeType = gradeType;
    }

    public ExamStatus getExamStatus() {
        return this.examStatus;
    }

    public void setExamStatus(ExamStatus examStatus) {
        this.examStatus = examStatus;
    }

    public Float getScore() {
        return this.score;
    }

    public void setScore(Float score) {
        this.score = score;
    }

    public Course getCourse() {
        return this.course;
    }

    public void setCourse(Course course) {
        this.course = course;
    }

    public Student getStd() {
        return this.std;
    }

    public void setStd(Student std) {
        this.std = std;
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public GradeModifyStatus getStatus() {
        return this.status;
    }

    public void setStatus(GradeModifyStatus status) {
        this.status = status;
    }

    public String getApplyer() {
        return this.applyer;
    }

    public void setApplyer(String applyer) {
        this.applyer = applyer;
    }

    public String getAuditer() {
        return this.auditer;
    }

    public void setAuditer(String auditer) {
        this.auditer = auditer;
    }

    public String getFinalAuditer() {
        return this.finalAuditer;
    }

    public void setFinalAuditer(String finalAuditer) {
        this.finalAuditer = finalAuditer;
    }

    public String getScoreText() {
        return this.scoreText;
    }

    public void setScoreText(String scoreText) {
        this.scoreText = scoreText;
    }

    public ExamStatus getExamStatusBefore() {
        return this.examStatusBefore;
    }

    public void setExamStatusBefore(ExamStatus examStatusBefore) {
        this.examStatusBefore = examStatusBefore;
    }

    public String getOrigScoreText() {
        return this.origScoreText;
    }

    public void setOrigScoreText(String origScoreText) {
        this.origScoreText = origScoreText;
    }

    public Float getOrigScore() {
        return this.origScore;
    }

    public void setOrigScore(Float origScore) {
        this.origScore = origScore;
    }

    public boolean hasChange() {
        if (this.score == null || this.origScore == null) {
            return this.score != this.origScore || !this.examStatus.equals((Object)this.examStatusBefore);
        }
        return !this.score.equals(this.origScore) || !this.examStatus.equals((Object)this.examStatusBefore);
    }

    public String getApplyReason() {
        return this.applyReason;
    }

    public void setApplyReason(String applyReason) {
        this.applyReason = applyReason;
    }

    public String getAuditReason() {
        return this.auditReason;
    }

    public void setAuditReason(String auditReason) {
        this.auditReason = auditReason;
    }

    public static enum GradeModifyStatus {
        NOT_AUDIT("\u672a\u5ba1\u6838"),
        DEPART_AUDIT_PASSED("\u9662\u7cfb\u5ba1\u6838\u901a\u8fc7"),
        DEPART_AUDIT_UNPASSED("\u9662\u7cfb\u5ba1\u6838\u672a\u901a\u8fc7"),
        ADMIN_AUDIT_PASSED("\u9662\u957f\u5ba1\u6838\u901a\u8fc7"),
        ADMIN_AUDIT_UNPASSED("\u9662\u957f\u5ba1\u6838\u672a\u901a\u8fc7"),
        FINAL_AUDIT_PASSED("\u6700\u7ec8\u5ba1\u6838\u901a\u8fc7"),
        FINAL_AUDIT_UNPASSED("\u6700\u7ec8\u5ba1\u6838\u672a\u901a\u8fc7"),
        GRADE_DELETED("\u6210\u7ee9\u5df2\u88ab\u5220\u9664");

        private String fullName;

        private GradeModifyStatus() {
        }

        private GradeModifyStatus(String fullName) {
            this.fullName = fullName;
        }

        public String getFullName() {
            return this.fullName;
        }
    }
}

