/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.transcript.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.transcript.service.TranscriptDataProvider;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.ExecutivePlan;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.StdPlan;
import org.openurp.edu.program.plan.service.CoursePlanProvider;

public class TranscriptPlanCourseProvider
extends BaseServiceImpl
implements TranscriptDataProvider {
    private CoursePlanProvider coursePlanProvider;

    @Override
    public String getDataName() {
        return "planCourses";
    }

    @Override
    public Object getDatas(List<Student> stds, Map<String, String> options) {
        Map datas = CollectUtils.newHashMap();
        for (Student std : stds) {
            datas.put(std, this.getPlanCourses(std));
        }
        return datas;
    }

    private List<PlanCourse> getPlanCourses(Student std) {
        ExecutivePlan coursePlan;
        ArrayList<PlanCourse> planCourses = new ArrayList<PlanCourse>();
        StdPlan personalPlan = this.coursePlanProvider.getPersonalPlan(std);
        if (personalPlan != null) {
            List<CourseGroup> courseGroups = personalPlan.getGroups();
            for (CourseGroup courseGroup : courseGroups) {
                if (courseGroup == null) continue;
                planCourses.addAll(courseGroup.getPlanCourses());
            }
        }
        if (personalPlan == null && (coursePlan = this.coursePlanProvider.getExecutivePlan(std)) != null) {
            for (CourseGroup courseGroup : coursePlan.getGroups()) {
                planCourses.addAll(courseGroup.getPlanCourses());
            }
        }
        return planCourses;
    }

    public void setCoursePlanProvider(CoursePlanProvider coursePlanProvider) {
        this.coursePlanProvider = coursePlanProvider;
    }
}

