/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.schedule.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.Entity;
import org.openurp.base.edu.model.TimeSetting;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.resource.model.Classroom;
import org.openurp.base.std.model.Squad;
import org.openurp.base.std.model.Student;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzActivity;

public class CourseTable {
    public static final String Squad = "squad";
    public static final String STD = "std";
    public static final String TEACHER = "teacher";
    public static final String ROOM = "room";
    public static final Map<String, Object> resourceClass = CollectUtils.newHashMap();
    String kind;
    Entity<?> resource;
    List<Clazz> clazzes;
    TimeSetting timeSetting;
    List<ClazzActivity> activities = CollectUtils.newArrayList();
    Float credits = null;

    public CourseTable(Entity<?> resource, String kind) {
        this.kind = kind;
        this.resource = resource;
    }

    public Float getCredits() {
        if (null == this.credits) {
            if (null == this.clazzes) {
                return null;
            }
            float credits = 0.0f;
            for (Clazz clazz : this.clazzes) {
                credits += clazz.getCourse().getDefaultCredits();
            }
            return new Float(credits);
        }
        return this.credits;
    }

    public void extractTaskFromActivity() {
        if (null == this.activities) {
            return;
        }
        Set clazzSet = CollectUtils.newHashSet();
        for (ClazzActivity activity : this.activities) {
            Clazz clazz = activity.getClazz();
            if (clazzSet.contains(clazz)) continue;
            clazzSet.add(clazz);
        }
        this.clazzes = CollectUtils.newArrayList((Collection)clazzSet);
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public Entity<?> getResource() {
        return this.resource;
    }

    public void setResource(Entity<Long> resource) {
        this.resource = resource;
    }

    public List<Clazz> getClazzes() {
        return this.clazzes;
    }

    public void setClazzes(List<Clazz> clazzes) {
        this.clazzes = clazzes;
    }

    public List<ClazzActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<ClazzActivity> activities) {
        this.activities = activities;
    }

    public void setCredits(Float credits) {
        this.credits = credits;
    }

    public static <T> Class<T> getResourceClass(String kind) {
        Class clazz = (Class)resourceClass.get(kind);
        if (null != clazz) {
            return clazz;
        }
        throw new RuntimeException("not supported Resource stdType:" + kind);
    }

    public TimeSetting getTimeSetting() {
        return this.timeSetting;
    }

    public void setTimeSetting(TimeSetting timeSetting) {
        this.timeSetting = timeSetting;
    }

    static {
        resourceClass.put(Squad, Squad.class);
        resourceClass.put(STD, Student.class);
        resourceClass.put(TEACHER, Teacher.class);
        resourceClass.put(ROOM, Classroom.class);
    }
}

