/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.service.impl;

import java.io.Serializable;
import java.sql.Date;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.entity.util.EntityUtils;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.Throwables;
import org.openurp.base.edu.model.Project;
import org.openurp.base.service.SquadService;
import org.openurp.base.std.model.Squad;
import org.openurp.base.std.model.Student;

public class SquadServiceImpl
extends BaseServiceImpl
implements SquadService {
    @Override
    public Squad getSquad(Long id) {
        return (Squad)this.entityDao.get(Squad.class, (Serializable)id);
    }

    @Override
    public Squad getSquad(String code) {
        OqlBuilder query = OqlBuilder.from(Squad.class, (String)"squad");
        query.where("squad.code=:code", (Object)code);
        List rs = this.entityDao.search((QueryBuilder)query);
        if (rs.isEmpty()) {
            return null;
        }
        return (Squad)rs.get(0);
    }

    @Override
    public void removeSquad(Long id) {
        if (null == id) {
            return;
        }
        this.entityDao.remove(new Object[]{this.entityDao.get(Squad.class, (Serializable)id)});
    }

    @Override
    public void saveOrUpdate(Squad squad) {
        squad.setUpdatedAt(new Date(System.currentTimeMillis()));
        this.entityDao.saveOrUpdate(new Object[]{squad});
    }

    @Override
    public int updateActualStdCount(Long squadId) {
        int stdCount = 0;
        String updateHQL = "update Squad cls set cls.actualStdCount=(\nselect count(std.id) from Squad class1 join class1.students std where class1.id=cls.id and std.inSchool=1\n) where cls.id=:id";
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", squadId);
        try {
            this.entityDao.executeUpdate(updateHQL, params);
        }
        catch (RuntimeException e) {
            this.logger.info("execproduct is failedin update_classactualstdcount" + Throwables.getStackTrace((Throwable)e));
            throw e;
        }
        return stdCount;
    }

    @Override
    public int updateStdCount(Long squadId) {
        int stdCount = 0;
        String updateHQL = "update Squad cls set cls.stdCount=(\nselect count(std.id) from Squad class1 join class1.students std where class1.id=cls.id and std.active=1\n) where cls.id=:id";
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", squadId);
        try {
            this.entityDao.executeUpdate(updateHQL, params);
        }
        catch (RuntimeException e) {
            this.logger.info("execproduct is failedin update_classstdcount" + Throwables.getStackTrace((Throwable)e));
            throw e;
        }
        return stdCount;
    }

    @Override
    public void batchUpdateStdCountOfClass(String squadIdSeq) {
        Long[] squadIds = Strings.transformToLong((String[])Strings.split((String)squadIdSeq));
        if (null != squadIds) {
            for (int i = 0; i < squadIds.length; ++i) {
                this.updateActualStdCount(squadIds[i]);
                this.updateStdCount(squadIds[i]);
            }
        }
    }

    @Override
    public void batchUpdateStdCountOfClass(Long[] squadIds) {
        if (null != squadIds) {
            for (int i = 0; i < squadIds.length; ++i) {
                this.updateActualStdCount(squadIds[i]);
                this.updateStdCount(squadIds[i]);
            }
        }
    }

    @Override
    public void batchAddStudentClass(List students, List squades) {
        for (Squad squad : squades) {
            Set<Student> studentSet = squad.getAllStudents();
            for (Student student : students) {
                if (studentSet.contains(student)) continue;
                studentSet.add(student);
            }
        }
        this.entityDao.saveOrUpdate((Collection)students);
        this.entityDao.saveOrUpdate((Collection)squades);
    }

    @Override
    public void batchRemoveStudentClass(List students, List squades) {
        for (Squad squad : squades) {
            Set<Student> studentSet = squad.getAllStudents();
            for (Student student : students) {
                if (!studentSet.contains(student)) continue;
                studentSet.remove(student);
            }
        }
        this.entityDao.saveOrUpdate((Collection)students);
        this.entityDao.saveOrUpdate((Collection)squades);
    }

    @Override
    public void updateStudentSquad(Student std, Collection squades, Project project) {
        List orig = EntityUtils.extractIds((Collection)squades);
        List dest = EntityUtils.extractIds(Collections.singleton(std.getSquad()));
        List addClassList = CollectUtils.subtract((List)orig, (List)dest);
        List subClassList = CollectUtils.subtract((List)dest, (List)orig);
        this.batchRemoveStudentClass(Collections.singletonList(std), this.entityDao.get(Squad.class, "id", subClassList.toArray()));
        this.batchAddStudentClass(Collections.singletonList(std), this.entityDao.get(Squad.class, "id", addClassList.toArray()));
    }
}

