/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.service.impl;

import java.util.List;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.edu.model.TimeSetting;
import org.openurp.base.model.Campus;
import org.openurp.base.service.TimeSettingService;

public class TimeSettingServiceImpl
extends BaseServiceImpl
implements TimeSettingService {
    @Override
    public void saveTimeSetting(TimeSetting setting) {
        this.entityDao.saveOrUpdate(new Object[]{setting});
    }

    @Override
    public void removeTimeSetting(TimeSetting setting) {
        this.entityDao.remove(new Object[]{setting});
    }

    @Override
    public TimeSetting getClosestTimeSetting(Project project, Semester semester, Campus campus) {
        List<TimeSetting> settings;
        if (null != campus && !(settings = this.getSettings(project, semester, campus)).isEmpty()) {
            return settings.get(0);
        }
        settings = this.getSettings(project, semester, null);
        if (!settings.isEmpty()) {
            return settings.get(0);
        }
        return null;
    }

    private List<TimeSetting> getSettings(Project project, Semester semester, Campus campus) {
        OqlBuilder query = OqlBuilder.from(TimeSetting.class, (String)"ts");
        query.where("ts.project=:project", (Object)project);
        if (null != campus) {
            query.where("ts.campus=:campus", (Object)campus);
        }
        query.where("ts.beginOn <=:now and (ts.endOn is null or ts.endOn >=:now)", (Object)semester.getBeginOn());
        query.cacheable();
        return this.entityDao.search((QueryBuilder)query);
    }
}

