/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import org.beangle.commons.entity.Component;
import org.beangle.commons.lang.Objects;
import org.beangle.orm.hibernate.udt.WeekState;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Type;
import org.openurp.base.resource.model.Classroom;
import org.openurp.code.edu.model.ClassroomType;
import org.openurp.edu.clazz.model.ClazzActivity;

@Embeddable
public class Schedule
implements Serializable,
Cloneable,
Component {
    private static final long serialVersionUID = 3067092503219100019L;
    @NotNull
    private int creditHours;
    private int weekHours;
    @NotNull
    @Type(type="org.beangle.orm.hibernate.udt.WeekStateType")
    private WeekState weekstate = WeekState.Zero;
    @OneToMany(mappedBy="clazz", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private Set<ClazzActivity> activities = new HashSet<ClazzActivity>();
    @ManyToOne(fetch=FetchType.LAZY)
    private ClassroomType roomType;
    private boolean departArranged = true;

    public Schedule clone() {
        try {
            Schedule info = (Schedule)super.clone();
            info.setActivities(new HashSet<ClazzActivity>());
            return info;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Classroom> getRooms() {
        if (null != this.getActivities() && !this.getActivities().isEmpty()) {
            HashSet<Classroom> rooms = new HashSet<Classroom>();
            for (ClazzActivity session : this.getActivities()) {
                rooms.addAll(session.getRooms());
            }
            return rooms;
        }
        return Collections.emptySet();
    }

    public int getLastWeek() {
        return null != this.weekstate ? this.weekstate.getLast() : 0;
    }

    public Set<ClazzActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(Set<ClazzActivity> sessions) {
        this.activities = sessions;
    }

    public WeekState getWeekstate() {
        return this.weekstate;
    }

    public void setWeekstate(WeekState weekstate) {
        this.weekstate = weekstate;
    }

    public int getWeeks() {
        if (null == this.weekstate) {
            return 0;
        }
        return this.weekstate.getWeeks();
    }

    public static float calcWeekHours(float period, int weeks) {
        float wh = period / (float)weeks;
        return Schedule.reserve(wh, 2);
    }

    private static float reserve(float num, int precision) {
        int mutilply = (int)Math.pow(10.0, precision + 1);
        if ((num *= (float)mutilply) % 10.0f >= 5.0f) {
            num += 10.0f;
        }
        num -= num % 10.0f;
        return num / (float)mutilply;
    }

    public int getFirstWeek() {
        return null != this.weekstate ? this.weekstate.getFirst() : 0;
    }

    public int getCreditHours() {
        return this.creditHours;
    }

    public void setCreditHours(int creditHours) {
        this.creditHours = creditHours;
    }

    public ClassroomType getRoomType() {
        return this.roomType;
    }

    public void setRoomType(ClassroomType roomType) {
        this.roomType = roomType;
    }

    public Status getStatus() {
        if (this.creditHours == 0) {
            return Status.DONT_ARRANGE;
        }
        return this.getActivities().isEmpty() ? Status.NEED_ARRANGE : Status.ARRANGED;
    }

    public String toString() {
        return Objects.toStringBuilder((Object)this).add("weekstate", (Object)this.weekstate).add("period", (Object)this.creditHours).toString();
    }

    public boolean isDepartArranged() {
        return this.departArranged;
    }

    public void setDepartArranged(boolean departArranged) {
        this.departArranged = departArranged;
    }

    public void setWeekHours(int weekHours) {
        this.weekHours = weekHours;
    }

    public int getWeekHours() {
        return this.weekHours;
    }

    public static enum Status {
        NEED_ARRANGE("\u5f85\u5b89\u6392"),
        ARRANGED("\u5df2\u5b89\u6392"),
        DONT_ARRANGE("\u4e0d\u5b89\u6392");

        private String description;

        private Status(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

