/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.entity.metadata.Model;
import org.beangle.security.Securities;
import org.openurp.base.service.ProjectPropertyService;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.ExamStatus;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.grade.Grade;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.model.CourseGradeState;
import org.openurp.edu.grade.course.model.ExamGrade;
import org.openurp.edu.grade.course.model.GaGrade;
import org.openurp.edu.grade.course.service.CourseGradeCalculator;
import org.openurp.edu.grade.course.service.GradeRateService;
import org.openurp.edu.grade.course.service.NumPrecisionReserveMethod;
import org.openurp.edu.grade.course.service.ScoreConverter;
import org.openurp.edu.grade.course.service.impl.MoreHalfReserveMethod;

public class DefaultCourseGradeCalculator
implements CourseGradeCalculator {
    private static final GradeType Ga = new GradeType(GradeType.GA_ID);
    private static final GradeType MakeupGa = new GradeType(GradeType.MAKEUP_GA_ID);
    private static final GradeType Makeup = new GradeType(GradeType.MAKEUP_ID);
    private static final GradeType DelayGa = new GradeType(GradeType.DELAY_GA_ID);
    private static final GradeType Delay = new GradeType(GradeType.DELAY_ID);
    private static final GradeType End = new GradeType(GradeType.END_ID);
    protected EntityDao entityDao;
    protected GradeRateService gradeRateService;
    protected ProjectPropertyService projectPropertyService;
    private float minEndScore = 0.0f;
    private boolean endIsGaWhenFreeListening = true;
    protected NumPrecisionReserveMethod numPrecisionReserveMethod = new MoreHalfReserveMethod();

    @Override
    public void calcFinal(CourseGrade grade, CourseGradeState state) {
        if (!grade.isPublished()) {
            grade.setStatus(this.guessFinalStatus(grade));
        }
        this.updateScore(grade, this.calcScore(grade, state), null);
    }

    @Override
    public void calcAll(CourseGrade grade, CourseGradeState state) {
        this.calcEndGa(grade, state);
        this.calcMakeupDelayGa(grade, state);
    }

    @Override
    public GaGrade calcEndGa(CourseGrade grade, CourseGradeState state) {
        Long stdId = (Long)grade.getStd().getId();
        grade.setStd((Student)this.entityDao.get(Student.class, (Serializable)stdId));
        GaGrade gag = this.getGaGrade(grade, Ga);
        Float gaScore = this.calcEndGaScore(grade, state);
        this.updateScore(gag, gaScore, null);
        if (!gag.isPublished() && null != state) {
            gag.setStatus(state.getStatus(gag.getGradeType()));
        }
        if (!grade.isPublished()) {
            grade.setStatus(this.guessFinalStatus(grade));
        }
        if (gag.getStatus() == grade.getStatus()) {
            this.updateScore(grade, this.calcScore(grade, state), null);
        }
        return gag;
    }

    protected Float calcEndGaScore(CourseGrade grade, CourseGradeState state) {
        boolean isCheating = false;
        for (ExamGrade eg : grade.getExamGrades()) {
            if (eg.getGradeType().equals((Object)Makeup) || eg.getGradeType().equals((Object)Delay) || null == eg.getExamStatus() || !eg.getExamStatus().isCheating()) continue;
            isCheating = true;
            break;
        }
        if (isCheating) {
            return Float.valueOf(0.0f);
        }
        Float ga = null;
        GaGrade gaGrade = (GaGrade)grade.getGrade(Ga);
        if (gaGrade != null) {
            ga = gaGrade.getScore();
            if (grade.getExamGrades().isEmpty()) {
                return ga;
            }
        }
        ExamGrade endGrade = grade.getExamGrade(End);
        gaGrade = this.getGaGrade(grade, Ga);
        if (null != endGrade) {
            if (this.endIsGaWhenFreeListening && grade.isFreeListening()) {
                return this.addDelta(gaGrade, endGrade.getScore(), state);
            }
            if (!this.hasDelta(gaGrade) && null != endGrade.getScore() && Float.compare(endGrade.getScore().floatValue(), this.minEndScore) < 0) {
                return this.addDelta(gaGrade, endGrade.getScore(), state);
            }
        }
        double totalGa = 0.0;
        int totalPercent = 0;
        int scorePercent = 0;
        boolean hasEmptyEndGrade = false;
        for (ExamGrade examGrade : grade.getExamGrades()) {
            Short myPercent;
            if (examGrade.getGradeType().equals((Object)Delay)) continue;
            if (examGrade.getGradeType().equals((Object)End) && null == examGrade.getScore()) {
                hasEmptyEndGrade = true;
            }
            if (null == (myPercent = this.getPercent(examGrade, grade, state)) || myPercent <= 0 || null == examGrade.getScore() && (null == examGrade.getExamStatus() || ((Integer)examGrade.getExamStatus().getId()).equals(ExamStatus.NORMAL))) continue;
            Float score = examGrade.getScore();
            if (examGrade.getScorePercent() != null) {
                myPercent = examGrade.getScorePercent();
            }
            totalPercent += myPercent.shortValue();
            if (null == score) continue;
            scorePercent += myPercent.shortValue();
            totalGa += (double)myPercent.shortValue() / 100.0 * score.doubleValue();
        }
        if (totalPercent < 100) {
            if (totalPercent > 0) {
                return null;
            }
            return gaGrade.getScore();
        }
        if (scorePercent <= 51 || hasEmptyEndGrade) {
            return null;
        }
        return this.addDelta(gaGrade, new Float(totalGa), state);
    }

    @Override
    public GaGrade calcMakeupDelayGa(CourseGrade grade, CourseGradeState state) {
        Long stdId = (Long)grade.getStd().getId();
        grade.setStd((Student)this.entityDao.get(Student.class, (Serializable)stdId));
        List<GradeType> gatypes = Arrays.asList(DelayGa, MakeupGa);
        GaGrade makeupDelayGa = null;
        ExamGrade makeupDelayGrade = null;
        for (GradeType gatype : gatypes) {
            GaGrade gag = this.getGaGrade(grade, gatype);
            Float gaScore = null;
            if (gatype.equals((Object)DelayGa)) {
                gaScore = this.calcDelayGaScore(grade, state);
                makeupDelayGrade = grade.getExamGrade(Delay);
            } else {
                gaScore = this.calcMakeupGaScore(grade, state);
                makeupDelayGrade = grade.getExamGrade(Makeup);
            }
            if (null == gaScore && (null == makeupDelayGrade || ((Integer)makeupDelayGrade.getExamStatus().getId()).equals(ExamStatus.NORMAL))) {
                Grade gaGrade = grade.getGrade(gatype);
                grade.getGaGrades().remove(gaGrade);
                continue;
            }
            this.updateScore(gag, gaScore, null);
            if (!gag.isPublished() && null != state) {
                gag.setStatus(state.getStatus(gag.getGradeType()));
            }
            makeupDelayGa = gag;
        }
        if (null != makeupDelayGa) {
            if (!grade.isPublished()) {
                grade.setStatus(this.guessFinalStatus(grade));
            }
            if (makeupDelayGa.getStatus() == grade.getStatus()) {
                this.updateScore(grade, this.calcScore(grade, state), null);
            }
        }
        return makeupDelayGa;
    }

    private Short getPercent(ExamGrade eg, CourseGrade cg, CourseGradeState cgs) {
        if (null != eg.getScorePercent()) {
            return eg.getScorePercent();
        }
        if (eg.getGradeType().equals((Object)Delay)) {
            ExamGrade end = cg.getExamGrade(End);
            if (null != end && null != end.getScorePercent()) {
                return end.getScorePercent();
            }
            return null == cgs ? null : cgs.getPercent(End);
        }
        return null == cgs ? null : cgs.getPercent(eg.getGradeType());
    }

    protected Float calcDelayGaScore(CourseGrade grade, CourseGradeState state) {
        ExamGrade deGrade;
        Float gascore = null;
        GaGrade gaGrade = (GaGrade)grade.getGrade(DelayGa);
        if (gaGrade != null) {
            gascore = gaGrade.getScore();
            if (grade.getExamGrade(Delay) == null) {
                return gascore;
            }
        }
        if ((deGrade = grade.getExamGrade(Delay)) == null) {
            return null;
        }
        if (null != deGrade.getExamStatus() && deGrade.getExamStatus().isCheating()) {
            return Float.valueOf(0.0f);
        }
        boolean delayIsGa = this.projectPropertyService.get(grade.getProject(), "edu.grade.delay_is_ga", "false").equals("true");
        if (delayIsGa) {
            return deGrade.getScore();
        }
        gaGrade = this.getGaGrade(grade, DelayGa);
        if (this.endIsGaWhenFreeListening && grade.isFreeListening()) {
            return this.addDelta(gaGrade, deGrade.getScore(), state);
        }
        if (!this.hasDelta(gaGrade) && null != deGrade.getScore() && Float.compare(deGrade.getScore().floatValue(), this.minEndScore) < 0) {
            return this.addDelta(gaGrade, deGrade.getScore(), state);
        }
        double ga = 0.0;
        int totalPercent = 0;
        int scorePercent = 0;
        for (ExamGrade examGrade : grade.getExamGrades()) {
            Short myPercent;
            if (examGrade.getGradeType().equals((Object)End) || null == (myPercent = this.getPercent(examGrade, grade, state)) || myPercent <= 0 || null == examGrade.getScore() && (null == examGrade.getExamStatus() || ((Integer)examGrade.getExamStatus().getId()).equals(ExamStatus.NORMAL))) continue;
            Float score = examGrade.getScore();
            totalPercent += myPercent.shortValue();
            if (null == score) continue;
            scorePercent += myPercent.shortValue();
            ga += (double)myPercent.shortValue() / 100.0 * score.doubleValue();
        }
        if (totalPercent < 100) {
            return null;
        }
        return scorePercent < 51 ? null : this.addDelta(gaGrade, new Float(ga), state);
    }

    protected Float calcMakeupGaScore(CourseGrade grade, CourseGradeState gradeState) {
        ExamGrade makeup;
        Float gascore = null;
        GaGrade gaGrade = (GaGrade)grade.getGrade(MakeupGa);
        if (gaGrade != null) {
            gascore = gaGrade.getScore();
            if (grade.getExamGrade(Makeup) == null) {
                return gascore;
            }
        }
        if (null == (makeup = grade.getExamGrade(Makeup)) || null == makeup.getScore()) {
            return null;
        }
        if (null != makeup.getExamStatus() && makeup.getExamStatus().isCheating()) {
            return Float.valueOf(0.0f);
        }
        gaGrade = this.getGaGrade(grade, MakeupGa);
        this.addDelta(gaGrade, makeup.getScore(), gradeState);
        boolean makeupIsGa = this.projectPropertyService.get(grade.getProject(), "edu.grade.makeup_is_ga", "false").equals("true");
        if (makeupIsGa) {
            return gaGrade.getScore();
        }
        return Float.valueOf(Float.compare(gaGrade.getScore().floatValue(), 60.0f) >= 0 ? 60.0f : gaGrade.getScore().floatValue());
    }

    protected Float calcScore(CourseGrade grade, CourseGradeState state) {
        Float best = null;
        for (GaGrade gg : grade.getGaGrades()) {
            if (null == gg.getScore()) continue;
            Float myScore = null;
            if (!gg.getGradeType().equals((Object)Ga)) {
                if (gg.isPublished()) {
                    myScore = gg.getScore();
                }
            } else {
                myScore = gg.getScore();
            }
            if (null == best) {
                best = myScore;
            }
            if (null == myScore || myScore.compareTo(best) <= 0) continue;
            best = myScore;
        }
        return best;
    }

    private GaGrade getGaGrade(CourseGrade grade, GradeType gradeType) {
        GaGrade gaGrade = (GaGrade)grade.getGrade(gradeType);
        if (null != gaGrade) {
            return gaGrade;
        }
        gaGrade = (GaGrade)Model.newInstance(GaGrade.class);
        gaGrade.setGradingMode(grade.getGradingMode());
        gaGrade.setGradeType(gradeType);
        gaGrade.setUpdatedAt(new Date());
        grade.addGaGrade(gaGrade);
        return gaGrade;
    }

    private int guessFinalStatus(CourseGrade grade) {
        Grade delay;
        Grade makeup;
        int status = 0;
        Grade ga = grade.getGrade(Ga);
        if (null != ga && ga.getStatus() > status) {
            status = ga.getStatus();
        }
        if (null != (makeup = grade.getGrade(MakeupGa)) && makeup.getStatus() > status) {
            status = makeup.getStatus();
        }
        if (null != (delay = grade.getGrade(DelayGa)) && delay.getStatus() > status) {
            status = delay.getStatus();
        }
        return status;
    }

    @Override
    public final void updateScore(CourseGrade grade, Float score, GradingMode newStyle) {
        GradingMode gradingMode = newStyle;
        if (null == gradingMode) {
            gradingMode = grade.getGradingMode();
        } else {
            grade.setGradingMode(gradingMode);
        }
        ScoreConverter converter = this.gradeRateService.getConverter(grade.getProject(), gradingMode);
        grade.setScore(score);
        grade.setScoreText(converter.convert(score));
        if (null != grade.getCourseTakeType() && ((Integer)grade.getCourseTakeType().getId()).equals(5)) {
            grade.setPassed(true);
        } else {
            grade.setPassed(converter.isPassed(grade.getScore()));
        }
        if (((Integer)grade.getCourseTakeType().getId()).equals(5)) {
            if (null == grade.getScore()) {
                grade.setGp(null);
            } else {
                grade.setGp(converter.calcGp(grade.getScore()));
            }
        } else {
            grade.setGp(converter.calcGp(grade.getScore()));
        }
        grade.setOperator(Securities.getUsername());
        if (null == grade.getCreatedAt()) {
            grade.setCreatedAt(new Date());
        }
        grade.setUpdatedAt(new Date());
    }

    @Override
    public final void updateScore(ExamGrade eg, Float score, GradingMode newStyle) {
        eg.setScore(score);
        GradingMode gradingMode = newStyle;
        if (null == gradingMode) {
            gradingMode = eg.getGradingMode();
        } else {
            eg.setGradingMode(gradingMode);
        }
        ScoreConverter converter = this.gradeRateService.getConverter(eg.getCourseGrade().getProject(), eg.getGradingMode());
        eg.setScoreText(converter.convert(eg.getScore()));
        eg.setPassed(converter.isPassed(eg.getScore()));
        if (null == eg.getCreatedAt()) {
            eg.setCreatedAt(new Date());
        }
        eg.setUpdatedAt(new Date());
        eg.setOperator(Securities.getUsername());
    }

    @Override
    public final void updateScore(GaGrade gag, Float score, GradingMode newStyle) {
        gag.setScore(score);
        GradingMode gradingMode = newStyle;
        if (null == gradingMode) {
            gradingMode = gag.getGradingMode();
        } else {
            gag.setGradingMode(gradingMode);
        }
        ScoreConverter converter = this.gradeRateService.getConverter(gag.getCourseGrade().getProject(), gradingMode);
        gag.setScoreText(converter.convert(gag.getScore()));
        gag.setPassed(converter.isPassed(gag.getScore()));
        gag.setUpdatedAt(new Date());
        if (null == gag.getCreatedAt()) {
            gag.setCreatedAt(new Date());
        }
        gag.setOperator(Securities.getUsername());
        if (((Integer)gag.getCourseGrade().getCourseTakeType().getId()).equals(5)) {
            if (null == gag.getScore()) {
                gag.setGp(null);
            } else {
                gag.setGp(converter.calcGp(gag.getScore()));
            }
        } else {
            gag.setGp(converter.calcGp(gag.getScore()));
        }
    }

    protected boolean hasDelta(GaGrade gaGrade) {
        return null != gaGrade.getDelta();
    }

    protected Float getDelta(GaGrade gaGrade, Float score, CourseGradeState state) {
        return gaGrade.getDelta();
    }

    private final Float addDelta(GaGrade gaGrade, Float score, CourseGradeState state) {
        if (null == score) {
            return null;
        }
        Float delta = this.getDelta(gaGrade, score, state);
        if (null != delta) {
            Float ga = new Float(this.reserve((double)(delta.floatValue() + score.floatValue()), state));
            gaGrade.setScore(ga);
            return ga;
        }
        Float ga = this.reserve(score, state);
        gaGrade.setScore(ga);
        return ga;
    }

    protected Float reserve(Float score, CourseGradeState state) {
        if (null == score) {
            return score;
        }
        int precision = null == state ? 0 : state.getScorePrecision();
        return Float.valueOf(this.numPrecisionReserveMethod.reserve(score.floatValue(), precision));
    }

    protected double reserve(double score, CourseGradeState state) {
        int precision = null == state ? 0 : state.getScorePrecision();
        return this.numPrecisionReserveMethod.reserve(score, precision);
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public void setGradeRateService(GradeRateService gradeRateService) {
        this.gradeRateService = gradeRateService;
    }

    @Override
    public GradeRateService getGradeRateService() {
        return this.gradeRateService;
    }

    public float getMinEndScore() {
        return this.minEndScore;
    }

    public void setMinEndScore(float minEndScore) {
        this.minEndScore = minEndScore;
    }

    public boolean isEndIsGaWhenFreeListening() {
        return this.endIsGaWhenFreeListening;
    }

    public void setEndIsGaWhenFreeListening(boolean endIsGaWhenFreeListening) {
        this.endIsGaWhenFreeListening = endIsGaWhenFreeListening;
    }

    public NumPrecisionReserveMethod getNumPrecisionReserveMethod() {
        return this.numPrecisionReserveMethod;
    }

    public void setNumPrecisionReserveMethod(NumPrecisionReserveMethod numPrecisionReserveMethod) {
        this.numPrecisionReserveMethod = numPrecisionReserveMethod;
    }

    public void setProjectPropertyService(ProjectPropertyService projectPropertyService) {
        this.projectPropertyService = projectPropertyService;
    }
}

