/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.Operation;
import org.openurp.code.edu.model.GradeType;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.model.CourseGradeState;
import org.openurp.edu.grade.course.service.CourseGradeCalculator;
import org.openurp.edu.grade.course.service.CourseGradePublishListener;

public class RecalcGpPublishListener
implements CourseGradePublishListener {
    protected CourseGradeCalculator calculator;

    @Override
    public List<Operation> onPublish(CourseGrade grade, GradeType[] gradeTypes) {
        for (GradeType gradeType : gradeTypes) {
            if (!((Integer)gradeType.getId()).equals(GradeType.MAKEUP_GA_ID) && !((Integer)gradeType.getId()).equals(GradeType.DELAY_GA_ID)) continue;
            this.calculator.calcMakeupDelayGa(grade, null);
            return Operation.saveOrUpdate((Object[])new Object[]{grade}).build();
        }
        return Collections.emptyList();
    }

    @Override
    public List<Operation> onPublish(Collection<CourseGrade> grades, CourseGradeState gradeState, GradeType[] gradeTypes) {
        List operations = CollectUtils.newArrayList();
        boolean hasMakeupOrDelay = false;
        for (GradeType gradeType : gradeTypes) {
            if (!((Integer)gradeType.getId()).equals(GradeType.MAKEUP_GA_ID) && !((Integer)gradeType.getId()).equals(GradeType.DELAY_GA_ID)) continue;
            hasMakeupOrDelay = true;
            break;
        }
        if (!hasMakeupOrDelay) {
            return operations;
        }
        for (CourseGrade grade : grades) {
            this.calculator.calcMakeupDelayGa(grade, gradeState);
            operations.addAll(Operation.saveOrUpdate((Object[])new Object[]{grade}).build());
        }
        return operations;
    }

    public void setCalculator(CourseGradeCalculator calculator) {
        this.calculator = calculator;
    }
}

