/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service.listeners;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.edu.model.Course;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.service.impl.GradeComparator;
import org.openurp.edu.grade.plan.model.AuditCourseResult;
import org.openurp.edu.grade.plan.model.AuditGroupResult;
import org.openurp.edu.grade.plan.service.AuditPlanContext;
import org.openurp.edu.grade.plan.service.AuditPlanListener;
import org.openurp.edu.grade.plan.service.StdGrade;
import org.openurp.edu.program.model.AlternativeCourse;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.plan.service.AlternativeCourseService;

public class PlanAuditAlternativeCourseListener
implements AuditPlanListener {
    private AlternativeCourseService alternativeCourseService;
    private static final String alternatives_str = "alternatives";

    private String getGroupKey(CourseGroup courseGroup) {
        return courseGroup.getName() + "c";
    }

    @Override
    public boolean startPlanAudit(AuditPlanContext context) {
        context.getParams().put(alternatives_str, this.alternativeCourseService.getAlternativeCourses(context.getResult().getStd()));
        return true;
    }

    @Override
    public void endPlanAudit(AuditPlanContext context) {
    }

    @Override
    public boolean startCourseAudit(AuditPlanContext context, AuditGroupResult groupResult, PlanCourse planCourse) {
        Set substituted = (Set)context.getParams().get(this.getGroupKey(planCourse.getGroup()));
        return !substituted.contains(planCourse.getCourse());
    }

    @Override
    public boolean startGroupAudit(AuditPlanContext context, CourseGroup courseGroup, AuditGroupResult groupResult) {
        Set substituted = (Set)context.getParams().get(this.getGroupKey(courseGroup));
        if (null == substituted) {
            substituted = CollectUtils.newHashSet();
            context.getParams().put(this.getGroupKey(courseGroup), substituted);
        }
        List alternatives = (List)context.getParams().get(alternatives_str);
        StdGrade stdGrade = context.getStdGrade();
        Map courseMap = CollectUtils.newHashMap();
        for (PlanCourse planCourse : courseGroup.getPlanCourses()) {
            courseMap.put(planCourse.getCourse(), planCourse);
        }
        String[] auditTerms = context.getAuditTerms();
        boolean needCheckTerm = null != auditTerms && auditTerms.length >= 0;
        for (AlternativeCourse sc : alternatives) {
            if (!courseMap.keySet().containsAll(sc.getOlds()) || !this.isSubstitutes(stdGrade, sc)) continue;
            List substituteGrades = CollectUtils.newArrayList();
            for (Course c : sc.getNews()) {
                substituteGrades.addAll(stdGrade.getGrades(c));
                stdGrade.addNoGradeCourse(c);
            }
            for (Course ori : sc.getOlds()) {
                PlanCourse planCourse = (PlanCourse)courseMap.get(ori);
                if (needCheckTerm) {
                    boolean inTerm = false;
                    for (int j = 0; j < auditTerms.length && !(inTerm = planCourse.getTerms().contains(Integer.valueOf(auditTerms[j]))); ++j) {
                    }
                    if (!inTerm) continue;
                }
                AuditCourseResult planCourseResult = new AuditCourseResult(planCourse);
                planCourseResult.checkPassed(stdGrade.getGrades(ori), substituteGrades);
                if (!planCourseResult.isPassed()) continue;
                courseMap.remove(ori);
                stdGrade.addNoGradeCourse(ori);
                groupResult.addCourseResult(planCourseResult);
                groupResult.checkPassed(false);
                substituted.add(ori);
            }
        }
        return true;
    }

    protected boolean isSubstitutes(StdGrade stdGrade, AlternativeCourse alternative) {
        Set allCourses = CollectUtils.newHashSet(alternative.getOlds());
        allCourses.addAll(alternative.getNews());
        Map subGrades = CollectUtils.newHashMap();
        for (Course course : allCourses) {
            List<CourseGrade> grades = stdGrade.getGrades(course);
            if (!CollectUtils.isNotEmpty(grades)) continue;
            subGrades.put(course, grades.get(0));
        }
        if (GradeComparator.isSubstitute(alternative, subGrades)) {
            for (Course course : allCourses) {
                stdGrade.useGrades(course);
            }
            return true;
        }
        return false;
    }

    public AlternativeCourseService getAlternativeCourseService() {
        return this.alternativeCourseService;
    }

    public void setAlternativeCourseService(AlternativeCourseService alternativeCourseService) {
        this.alternativeCourseService = alternativeCourseService;
    }
}

