/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.major.service.impl;

import java.util.Date;
import java.util.List;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.model.AuditStatus;
import org.openurp.edu.program.major.service.MajorPlanAuditService;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.ExecutiveCourseGroup;
import org.openurp.edu.program.model.ExecutivePlan;
import org.openurp.edu.program.model.ExecutivePlanCourse;
import org.openurp.edu.program.model.MajorPlan;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.plan.dao.PlanCourseGroupCommonDao;

public class MajorPlanAuditServiceImpl
extends BaseServiceImpl
implements MajorPlanAuditService {
    private PlanCourseGroupCommonDao planCourseGroupCommonDao;

    @Override
    public void audit(List<MajorPlan> plans, AuditStatus status) {
        for (MajorPlan plan : plans) {
            if (!this.canTransferTo(plan.getProgram().getStatus(), status)) continue;
            plan.getProgram().setStatus(status);
            this.entityDao.saveOrUpdate(new Object[]{plan.getProgram(), plan});
            Program program = plan.getProgram();
            OqlBuilder q = OqlBuilder.from(ExecutivePlan.class, (String)"ep");
            q.where("ep.program=:program", (Object)program);
            List eps = this.entityDao.search((QueryBuilder)q);
            if (!status.equals((Object)AuditStatus.ACCEPTED) || !eps.isEmpty()) continue;
            ExecutivePlan ep = new ExecutivePlan();
            ep.setProgram(program);
            ep.setUpdatedAt(new Date());
            ep.setDepartment(program.getDepartment());
            ep.setCredits(plan.getCredits());
            this.entityDao.saveOrUpdate(new Object[]{ep});
            for (CourseGroup cg : plan.getGroups()) {
                if (cg.getParent() != null) continue;
                this.planCourseGroupCommonDao.copyCourseGroup(cg, null, ep, ExecutiveCourseGroup.class, ExecutivePlanCourse.class);
            }
        }
    }

    @Override
    public void revokeAccepted(List<MajorPlan> plans) {
        for (MajorPlan plan : plans) {
            if (!this.canTransferTo(plan.getProgram().getStatus(), AuditStatus.REJECTED) || plan.getProgram().getStatus() != AuditStatus.ACCEPTED) continue;
            plan.getProgram().setStatus(AuditStatus.REJECTED);
            this.entityDao.saveOrUpdate(new Object[]{plan});
        }
    }

    @Override
    public void submit(List<MajorPlan> plans) {
        for (MajorPlan plan : plans) {
            if (!this.canTransferTo(plan.getProgram().getStatus(), AuditStatus.SUBMITTED)) continue;
            plan.getProgram().setStatus(AuditStatus.SUBMITTED);
        }
        this.entityDao.saveOrUpdate(plans);
    }

    @Override
    public void revokeSubmitted(List<Program> plans) {
        for (Program program : plans) {
            if (!this.canTransferTo(program.getStatus(), AuditStatus.UNSUBMITTED)) continue;
            program.setStatus(AuditStatus.UNSUBMITTED);
        }
        this.entityDao.saveOrUpdate(plans);
    }

    private boolean canTransferTo(AuditStatus from, AuditStatus to) {
        switch (from) {
            case UNSUBMITTED: {
                return to == AuditStatus.SUBMITTED;
            }
            case SUBMITTED: {
                return to == AuditStatus.ACCEPTED || to == AuditStatus.REJECTED || to == AuditStatus.UNSUBMITTED;
            }
            case REJECTED: {
                return to == AuditStatus.SUBMITTED || to == AuditStatus.ACCEPTED;
            }
            case ACCEPTED: {
                return to == AuditStatus.REJECTED;
            }
        }
        return false;
    }

    @Override
    public MajorPlan getMajorMajorPlan(Long majorPlanId) {
        OqlBuilder query = OqlBuilder.from(MajorPlan.class, (String)"plan");
        query.where("plan.program.id=(select mp.program from org.openurp.edu.program.model.MajorPlan mp where mp.id = :mplanid)", (Object)majorPlanId);
        List majorPlans = this.entityDao.search((QueryBuilder)query);
        if (majorPlans == null || majorPlans.size() == 0) {
            throw new RuntimeException("Cannot find Major Plan");
        }
        if (majorPlans.size() > 1) {
            throw new RuntimeException("Error More than one Major Plan found");
        }
        return (MajorPlan)majorPlans.get(0);
    }

    public void setPlanCourseGroupCommonDao(PlanCourseGroupCommonDao planCourseGroupCommonDao) {
        this.planCourseGroupCommonDao = planCourseGroupCommonDao;
    }
}

