/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.openurp.base.edu.model.Course;
import org.openurp.base.std.model.Squad;
import org.openurp.edu.program.model.ExecutiveCourseGroup;
import org.openurp.edu.program.model.ExecutivePlan;
import org.openurp.edu.program.model.ExecutivePlanCourse;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.plan.dao.PlanCommonDao;
import org.openurp.edu.program.plan.service.ExecutivePlanQueryBuilder;
import org.openurp.edu.program.plan.service.ExecutivePlanService;

public class ExecutivePlanServiceImpl
extends BaseServiceImpl
implements ExecutivePlanService {
    private PlanCommonDao planCommonDao;

    @Override
    public Set<String> getUnusedCourseTypeNames(ExecutivePlan plan) {
        return this.planCommonDao.getUnusedCourseTypeNames(plan);
    }

    @Override
    public void removeExecutivePlan(ExecutivePlan plan) {
        this.planCommonDao.removePlan(plan);
    }

    @Override
    public void saveOrUpdateExecutivePlan(ExecutivePlan plan) {
        this.planCommonDao.saveOrUpdatePlan(plan);
    }

    @Override
    public float statPlanCredits(Long planId) {
        return this.statPlanCredits((ExecutivePlan)this.entityDao.get(ExecutivePlan.class, (Serializable)planId));
    }

    @Override
    public float statPlanCredits(ExecutivePlan plan) {
        return this.planCommonDao.statPlanCredits(plan);
    }

    @Override
    public boolean hasCourse(ExecutiveCourseGroup cgroup, Course course) {
        return this.planCommonDao.hasCourse(cgroup, course);
    }

    @Override
    public boolean hasCourse(ExecutiveCourseGroup cgroup, Course course, PlanCourse planCourse) {
        return this.planCommonDao.hasCourse(cgroup, course, planCourse);
    }

    public void setPlanCommonDao(PlanCommonDao planCommonDao) {
        this.planCommonDao = planCommonDao;
    }

    @Override
    public ExecutivePlan getExecutivePlanByAdminClass(Squad clazz) {
        List res = this.entityDao.search(ExecutivePlanQueryBuilder.build(clazz));
        return CollectUtils.isEmpty((Collection)res) ? null : (ExecutivePlan)res.get(0);
    }

    @Override
    public List<ExecutivePlanCourse> getPlanCourses(ExecutivePlan plan) {
        if (CollectUtils.isEmpty(plan.getGroups())) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ExecutivePlanCourse> planCourses = new ArrayList<ExecutivePlanCourse>();
        for (ExecutiveCourseGroup executiveCourseGroup : plan.getGroups()) {
            planCourses.addAll(executiveCourseGroup.getPlanCourses());
        }
        return planCourses;
    }
}

