/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.service.security;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.functor.Predicate;
import org.openurp.base.util.DataAuthorityPredicate;

public class DataAuthorityUtil {
    public static Map predicates = new HashMap();
    public static DataAuthorityPredicate predicateWithSimpleName = new DataAuthorityPredicate("", "", "stdType", "department");
    public static DataAuthorityPredicate departPpredicate = new DataAuthorityPredicate("", "", "", "department");

    public static boolean isInDataRealm(String category, Object entity, String stdTypeIdSeq, String departIdSeq) {
        return DataAuthorityUtil.getPredicate(category, entity, stdTypeIdSeq, departIdSeq).apply(entity);
    }

    public static boolean isInDataRealm(DataAuthorityPredicate predicate, Object entity, String stdTypeIdSeq, String departIdSeq) {
        predicate.setStdTypeDataRealm(stdTypeIdSeq);
        predicate.setDepartDataRealm(departIdSeq);
        return predicate.apply(entity);
    }

    private static DataAuthorityPredicate getPredicate(String category, Object entity, String stdTypeIdSeq, String departIdSeq) {
        DataAuthorityPredicate predicate = (DataAuthorityPredicate)predicates.get(category);
        if (null == predicate) {
            throw new RuntimeException("un registed predicate for " + entity.getClass().getName());
        }
        predicate.setStdTypeDataRealm(stdTypeIdSeq);
        predicate.setDepartDataRealm(departIdSeq);
        return predicate;
    }

    private static DataAuthorityPredicate getPredicate(String predicateName, String stdTypeIdSeq, String departIdSeq) {
        DataAuthorityPredicate predicate = (DataAuthorityPredicate)predicates.get(predicateName);
        if (null == predicate) {
            throw new RuntimeException("un registed predicate for " + predicateName);
        }
        predicate.setStdTypeDataRealm(stdTypeIdSeq);
        predicate.setDepartDataRealm(departIdSeq);
        return predicate;
    }

    public static void filter(Collection entities, String category, String stdTypeIdSeq, String departIdSeq) {
        if (null == entities || entities.isEmpty()) {
            return;
        }
        CollectUtils.filter((Collection)entities, (Predicate)DataAuthorityUtil.getPredicate(category, entities.iterator().next(), stdTypeIdSeq, departIdSeq));
    }

    public static void filter(String predicateName, Collection entities, String stdTypeIdSeq, String departIdSeq) {
        if (null == entities || entities.isEmpty()) {
            return;
        }
        CollectUtils.filter((Collection)entities, (Predicate)DataAuthorityUtil.getPredicate(predicateName, stdTypeIdSeq, departIdSeq));
    }

    public static List select(String predicateName, List entities, String stdTypeIdSeq, String departIdSeq) {
        return CollectUtils.select((List)entities, (Predicate)DataAuthorityUtil.getPredicate(predicateName, stdTypeIdSeq, departIdSeq));
    }

    public static List select(List entities, String category, String stdTypeIdSeq, String departIdSeq) {
        return CollectUtils.select((List)entities, (Predicate)DataAuthorityUtil.getPredicate(category, entities.iterator().next(), stdTypeIdSeq, departIdSeq));
    }

    public static void register(Class entityClass, DataAuthorityPredicate predicate) {
        predicates.put(entityClass.getName(), predicate);
    }

    public static void register(String predicateName, DataAuthorityPredicate predicate) {
        predicates.put(predicateName, predicate);
    }

    static {
        DataAuthorityPredicate taskForTeachDepartPredicate = new DataAuthorityPredicate("", "", "teachclass.stdType", "teachDepart");
        predicates.put("Squad", predicateWithSimpleName);
        predicates.put("Teacher", departPpredicate);
        predicates.put("Major", predicateWithSimpleName);
        predicates.put("Course", predicateWithSimpleName);
        predicates.put("TeachPlan", predicateWithSimpleName);
        predicates.put("TeachTaskForTeachDepart", taskForTeachDepartPredicate);
        predicates.put("Student", new DataAuthorityPredicate("", "", "stdType", "department"));
    }
}

