/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.hibernate.annotations.NaturalId;
import org.openurp.base.resource.model.Classroom;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ScheduleSuggestActivity;

@Entity(name="org.openurp.edu.clazz.model.ScheduleSuggest")
public class ScheduleSuggest
extends LongIdObject {
    private static final long serialVersionUID = -8849071317188023800L;
    @NaturalId
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Clazz clazz;
    @OneToMany(mappedBy="suggest", orphanRemoval=true, cascade={CascadeType.ALL})
    private Set<ScheduleSuggestActivity> activities = new HashSet<ScheduleSuggestActivity>();
    @ManyToMany
    private Set<Classroom> rooms = CollectUtils.newHashSet();
    @Size(max=500)
    private String remark;

    public ScheduleSuggest() {
    }

    public ScheduleSuggest(Long id) {
        super(id);
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public void setClazz(Clazz clazz) {
        this.clazz = clazz;
    }

    public Set<Classroom> getRooms() {
        return this.rooms;
    }

    public void setRooms(Set<Classroom> rooms) {
        this.rooms = rooms;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String otherSuggest) {
        this.remark = otherSuggest;
    }

    public boolean addRoom(Classroom room) {
        return this.rooms.add(room);
    }

    public boolean addRooms(Collection<Classroom> rooms) {
        return this.rooms.addAll(rooms);
    }

    public boolean removeRoom(Classroom room) {
        return this.rooms.remove((Object)room);
    }

    public boolean removeRooms(Collection<Classroom> rooms) {
        return this.rooms.removeAll(rooms);
    }

    public Set<ScheduleSuggestActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(Set<ScheduleSuggestActivity> activities) {
        this.activities = activities;
    }

    public void addActivity(ScheduleSuggestActivity activity) {
        activity.setSuggest(this);
        this.activities.add(activity);
    }

    public void addActivities(Collection<ScheduleSuggestActivity> activities) {
        for (ScheduleSuggestActivity activity : activities) {
            this.addActivity(activity);
        }
    }
}

