/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.code.edu.model.ExamType;
import org.openurp.code.edu.model.GradeType;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.exam.model.ExamTaker;
import org.openurp.edu.grade.course.service.MakeupStdStrategy;

public class MakeupByExamStrategy
extends BaseServiceImpl
implements MakeupStdStrategy {
    @Override
    public List<CourseTaker> getCourseTakers(Clazz clazz) {
        OqlBuilder query = OqlBuilder.from(CourseTaker.class, (String)"taker");
        query.where("taker.clazz = :clazz", (Object)clazz).where(" exists (from " + ExamTaker.class.getName() + " et  where et.std = taker.std and et.clazz = taker.clazz and et.examType.id in(:examTypeIds))", (Object)CollectUtils.newArrayList((Object[])new Integer[]{ExamType.MAKEUP, ExamType.DELAY}));
        return this.entityDao.search((QueryBuilder)query);
    }

    @Override
    public Map<Clazz, Number> getCourseTakerCounts(List<Clazz> clazzes) {
        if (clazzes.isEmpty()) {
            return CollectUtils.newHashMap();
        }
        Map clazzMap = CollectUtils.newHashMap();
        for (Clazz clazz : clazzes) {
            clazzMap.put((Long)clazz.getId(), clazz);
        }
        OqlBuilder query = OqlBuilder.from(CourseTaker.class, (String)"taker");
        query.where("taker.clazz in (:clazzes)", clazzes).where(" exists (from " + ExamTaker.class.getName() + " et  where et.std = taker.std and et.clazz = taker.clazz and et.examType.id in(:examTypeIds))", (Object)CollectUtils.newArrayList((Object[])new Integer[]{ExamType.MAKEUP, ExamType.DELAY})).select("taker.clazz.id,count(*)").groupBy("taker.clazz.id");
        List rs = this.entityDao.search((QueryBuilder)query);
        Map counts = CollectUtils.newHashMap();
        for (Object obj : rs) {
            Object[] count = (Object[])obj;
            counts.put((Clazz)clazzMap.get(count[0]), (Number)count[1]);
        }
        return counts;
    }

    @Override
    public String getClazzCondition(Integer gradeTypeId) {
        if (gradeTypeId.equals(GradeType.GA_ID)) {
            return "";
        }
        return "and exists(from " + ExamTaker.class.getName() + " et where et.clazz=clazz and et.examType.id in(" + ExamType.MAKEUP + "," + ExamType.DELAY + "))";
    }
}

