/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.internal;

import java.util.List;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.edu.model.Course;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.grade.course.service.GradeCourseTypeProvider;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.SharePlan;
import org.openurp.edu.program.plan.service.CoursePlanProvider;

public class GradeCourseTypeProviderImpl
extends BaseServiceImpl
implements GradeCourseTypeProvider {
    CoursePlanProvider coursePlanProvider;

    @Override
    public CourseType getCourseType(Student std, Course course, CourseType defaultCourseType) {
        CoursePlan plan = this.coursePlanProvider.getCoursePlan(std);
        CourseType planCourseType = null;
        if (null != plan) {
            block0: for (CourseGroup cg : plan.getGroups()) {
                if (cg == null) continue;
                for (PlanCourse pc : cg.getPlanCourses()) {
                    if (!pc.getCourse().equals(course)) continue;
                    planCourseType = cg.getCourseType();
                    continue block0;
                }
            }
        }
        if (null == planCourseType) {
            Integer grade = Integer.valueOf(std.getGrade().getCode().substring(0, 4));
            OqlBuilder builder = OqlBuilder.from(SharePlan.class, (String)"sp").join("sp.groups", "spg").join("spg.planCourses", "spgp").where("spgp.course=:course", (Object)course).where("sp.project=:project", (Object)std.getProject()).where("year(sp.beginOn)<=:grade and (sp.endOn is null or year(sp.endOn)>=:grade)", (Object)grade).select("spg.courseType");
            List types = this.entityDao.search((QueryBuilder)builder);
            if (!types.isEmpty()) {
                planCourseType = null != defaultCourseType && types.contains((Object)defaultCourseType) ? defaultCourseType : (CourseType)((Object)types.get(0));
            }
        }
        if (null == planCourseType) {
            planCourseType = defaultCourseType;
        }
        return planCourseType;
    }

    public void setCoursePlanProvider(CoursePlanProvider coursePlanProvider) {
        this.coursePlanProvider = coursePlanProvider;
    }
}

