/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.model;

import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.NumberIdTimeObject;
import org.hibernate.annotations.NaturalId;
import org.openurp.base.edu.model.Course;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.grade.plan.model.AuditGroupResult;

@Entity(name="org.openurp.edu.grade.plan.model.AuditPlanResult")
public class AuditPlanResult
extends NumberIdTimeObject<Long> {
    private static final long serialVersionUID = -3096429906586836701L;
    @NotNull
    @NaturalId
    @ManyToOne(fetch=FetchType.LAZY)
    private Student std;
    private float requiredCredits;
    private float passedCredits;
    private transient Set<Course> passedCourses = CollectUtils.newHashSet();
    @OneToMany(mappedBy="planResult", orphanRemoval=true, cascade={CascadeType.ALL})
    @OrderBy(value="indexno")
    private List<AuditGroupResult> groupResults = CollectUtils.newArrayList();
    private boolean passed;
    @Size(max=500)
    private String remark;
    @Size(max=1000)
    private String updates;
    private boolean archived = false;

    public AuditPlanResult() {
    }

    public AuditPlanResult(Student student) {
        this.setStd(student);
    }

    public List<AuditGroupResult> getTopGroupResults() {
        List results = CollectUtils.newArrayList();
        for (AuditGroupResult result : this.groupResults) {
            if (null != result.getParent()) continue;
            results.add(result);
        }
        return results;
    }

    public List<AuditGroupResult> getGroupResults() {
        return this.groupResults;
    }

    public void setGroupResults(List<AuditGroupResult> groupAuditResults) {
        this.groupResults = groupAuditResults;
    }

    public void addGroupResult(AuditGroupResult rs) {
        rs.setPlanResult(this);
        this.groupResults.add(rs);
    }

    public void removeGroupResult(AuditGroupResult rs) {
        rs.setPlanResult(null);
        this.groupResults.remove((Object)rs);
    }

    public AuditGroupResult getGroupResult(CourseType type) {
        if (null == this.groupResults) {
            return null;
        }
        for (AuditGroupResult groupAuditResult : this.groupResults) {
            AuditGroupResult res = this.getGroupResult(groupAuditResult, type);
            if (null == res) continue;
            return res;
        }
        return null;
    }

    private AuditGroupResult getGroupResult(AuditGroupResult groupResult, CourseType type) {
        if (type.equals((Object)groupResult.getCourseType())) {
            return groupResult;
        }
        for (AuditGroupResult childResult : groupResult.getChildren()) {
            AuditGroupResult res = this.getGroupResult(childResult, type);
            if (null == res) continue;
            return res;
        }
        return null;
    }

    public Student getStd() {
        return this.std;
    }

    public void setStd(Student student) {
        this.std = student;
    }

    public boolean isPassed() {
        return this.passed;
    }

    public void setPassed(boolean passed) {
        this.passed = passed;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getUpdates() {
        return this.updates;
    }

    public void setUpdates(String updates) {
        this.updates = updates;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public float getRequiredCredits() {
        return this.requiredCredits;
    }

    public void setRequiredCredits(float requiredCredits) {
        this.requiredCredits = requiredCredits;
    }

    public float getPassedCredits() {
        return this.passedCredits;
    }

    public void setPassedCredits(float passedCredits) {
        this.passedCredits = passedCredits;
    }

    public Set<Course> getPassedCourses() {
        return this.passedCourses;
    }

    public void setPassedCourses(Set<Course> passedCourses) {
        this.passedCourses = passedCourses;
    }

    public void addCredits(float credits) {
        this.passedCredits += credits;
    }

    public void reduceRequired(float credits) {
        this.requiredCredits -= credits;
        this.requiredCredits = this.requiredCredits < 0.0f ? 0.0f : this.requiredCredits;
    }
}

