/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.app.dao.hibernate;

import java.sql.Date;
import org.beangle.orm.hibernate.HibernateEntityDao;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.User;
import org.openurp.base.time.Terms;
import org.openurp.edu.program.app.dao.ExecutivePlanCourseModifyAuditDao;
import org.openurp.edu.program.app.model.ExecutivePlanCourseModify;
import org.openurp.edu.program.app.model.ExecutivePlanCourseModifyDetailAfter;
import org.openurp.edu.program.app.model.ExecutivePlanCourseModifyDetailBefore;
import org.openurp.edu.program.model.ExecutiveCourseGroup;
import org.openurp.edu.program.model.ExecutivePlan;
import org.openurp.edu.program.model.ExecutivePlanCourse;
import org.openurp.edu.program.plan.dao.PlanCourseCommonDao;
import org.openurp.edu.program.plan.dao.PlanCourseGroupCommonDao;
import org.openurp.edu.program.plan.service.ExecutivePlanAuditException;

public class ExecutivePlanCourseModifyAuditDaoHibernate
extends HibernateEntityDao
implements ExecutivePlanCourseModifyAuditDao {
    private PlanCourseCommonDao planCourseCommonDao;
    private PlanCourseGroupCommonDao planCourseGroupCommonDao;

    @Override
    public void approved(ExecutivePlanCourseModify apply, User assessor) throws ExecutivePlanAuditException {
        if (!ExecutivePlanCourseModify.INITREQUEST.equals(apply.getFlag())) {
            throw new ExecutivePlanAuditException("\u53ea\u80fd\u5bf9\u5f85\u5ba1\u6838\u7684\u7533\u8bf7\u8fdb\u884c\u5ba1\u6838");
        }
        ExecutivePlan plan = (ExecutivePlan)this.get(ExecutivePlan.class, apply.getExecutivePlan().getId());
        if (plan == null) {
            throw new ExecutivePlanAuditException("\u60a8\u8981\u4fee\u6539\u7684\u4e13\u4e1a\u57f9\u517b\u8ba1\u5212\u5df2\u7ecf\u4e0d\u5b58\u5728\u3002");
        }
        if (ExecutivePlanCourseModify.ADD.equals(apply.getRequisitionType())) {
            ExecutivePlanCourseModifyDetailAfter after = apply.getNewPlanCourse();
            ExecutivePlanCourse planCourse = new ExecutivePlanCourse();
            planCourse.setCourse(after.getCourse());
            planCourse.setTerms(after.getTerms());
            if (planCourse.getTerms() == null) {
                planCourse.setTerms(new Terms(0));
            }
            planCourse.setRemark(after.getRemark());
            planCourse.setCompulsory(after.isCompulsory());
            ExecutiveCourseGroup mg = (ExecutiveCourseGroup)this.get(ExecutiveCourseGroup.class, after.getFakeCourseGroup().getId());
            if (mg == null) {
                throw new ExecutivePlanAuditException("\u8bfe\u7a0b\u7ec4\u4e0d\u5b58\u5728\uff1a" + after.getFakeCourseGroup().getCourseType().getName());
            }
            planCourse.setGroup(mg);
            this.planCourseCommonDao.addPlanCourse(planCourse, plan);
        } else if (ExecutivePlanCourseModify.DELETE.equals(apply.getRequisitionType())) {
            ExecutivePlanCourseModifyDetailBefore before = apply.getOldPlanCourse();
            Course course = before.getCourse();
            ExecutivePlanCourse planCourse = this.planCourseCommonDao.getExecutivePlanCourseByCourse(plan, course);
            if (planCourse == null) {
                throw new ExecutivePlanAuditException("\u8bfe\u7a0b\u4e0d\u5b58\u5728\uff1a" + course);
            }
            this.planCourseCommonDao.removePlanCourse(planCourse, plan);
        } else if (ExecutivePlanCourseModify.MODIFY.equals(apply.getRequisitionType())) {
            ExecutivePlanCourseModifyDetailBefore before = apply.getOldPlanCourse();
            ExecutivePlanCourse planCourse = this.planCourseCommonDao.getExecutivePlanCourseByCourse(plan, before.getCourse());
            if (planCourse == null) {
                throw new ExecutivePlanAuditException("\u8bfe\u7a0b\u4e0d\u5b58\u5728\uff1a" + before.getCourse());
            }
            ExecutiveCourseGroup oldGroup = (ExecutiveCourseGroup)planCourse.getGroup();
            ExecutivePlanCourseModifyDetailAfter after = apply.getNewPlanCourse();
            planCourse.setCompulsory(after.isCompulsory());
            planCourse.setCourse(after.getCourse());
            planCourse.setTerms(after.getTerms());
            if (planCourse.getTerms() == null) {
                planCourse.setTerms(new Terms(0));
            }
            planCourse.setRemark(after.getRemark());
            ExecutiveCourseGroup mg = (ExecutiveCourseGroup)this.get(ExecutiveCourseGroup.class, after.getFakeCourseGroup().getId());
            if (mg == null) {
                throw new ExecutivePlanAuditException("\u8bfe\u7a0b\u7ec4\u4e0d\u5b58\u5728\uff1a" + after.getFakeCourseGroup().getCourseType().getName());
            }
            planCourse.setGroup(mg);
            this.planCourseCommonDao.updatePlanCourse(planCourse, plan);
            this.planCourseGroupCommonDao.saveOrUpdateCourseGroup(oldGroup);
        } else {
            throw new ExecutivePlanAuditException("\u9519\u8bef\u7684\u8ba1\u5212\u8bfe\u7a0b\u53d8\u66f4\u7533\u8bf7\u7c7b\u578b");
        }
        apply.setFlag(ExecutivePlanCourseModify.ACCEPT);
        apply.setAssessor(assessor);
        apply.setReplyDate(new Date(System.currentTimeMillis()));
        this.saveOrUpdate(new Object[]{apply});
    }

    @Override
    public void rejected(ExecutivePlanCourseModify apply, User assessor) throws ExecutivePlanAuditException {
        if (!ExecutivePlanCourseModify.INITREQUEST.equals(apply.getFlag())) {
            throw new ExecutivePlanAuditException("\u53ea\u80fd\u5bf9\u5f85\u5ba1\u6838\u7684\u7533\u8bf7\u8fdb\u884c\u5ba1\u6838");
        }
        apply.setFlag(ExecutivePlanCourseModify.REFUSE);
        apply.setAssessor(assessor);
        apply.setReplyDate(new Date(System.currentTimeMillis()));
        this.saveOrUpdate(new Object[]{apply});
    }

    public void setPlanCourseCommonDao(PlanCourseCommonDao planCourseCommonDao) {
        this.planCourseCommonDao = planCourseCommonDao;
    }

    public void setPlanCourseGroupCommonDao(PlanCourseGroupCommonDao planCourseGroupCommonDao) {
        this.planCourseGroupCommonDao = planCourseGroupCommonDao;
    }
}

