/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.model;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import org.beangle.commons.collection.CollectUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.model.Department;
import org.openurp.edu.program.model.AbstractCoursePlan;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.ExecutiveCourseGroup;

@Entity(name="org.openurp.edu.program.model.ExecutivePlan")
@Cacheable
@Cache(region="edu.course", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ExecutivePlan
extends AbstractCoursePlan {
    private static final long serialVersionUID = 7084539759992691314L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Department department;
    @OneToMany(orphanRemoval=true, targetEntity=ExecutiveCourseGroup.class, cascade={CascadeType.ALL})
    @JoinColumn(name="plan_id", nullable=false)
    @OrderBy(value="indexno")
    @Cache(region="edu.course", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<CourseGroup> groups = CollectUtils.newArrayList();

    @Override
    public List<CourseGroup> getGroups() {
        return this.groups;
    }

    @Override
    public void setGroups(List<CourseGroup> groups) {
        this.groups = groups;
    }

    public Object clone() throws CloneNotSupportedException {
        ExecutivePlan copy = (ExecutivePlan)super.clone();
        copy.setGroups(new ArrayList<CourseGroup>());
        copy.setId(null);
        return copy;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    @Override
    public Date getBeginOn() {
        return null != this.program ? this.program.getBeginOn() : null;
    }

    @Override
    public Date getEndOn() {
        return null != this.program ? this.program.getEndOn() : null;
    }

    public String toString() {
        return "ExecutivePlan [program=" + this.program + "]";
    }
}

