/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Numbers;
import org.beangle.commons.lang.Objects;
import org.beangle.commons.lang.Strings;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.ExecutiveCourseGroup;
import org.openurp.edu.program.plan.dao.PlanCourseGroupCommonDao;
import org.openurp.edu.program.plan.service.ExecutivePlanCourseGroupService;
import org.openurp.edu.program.plan.service.ExecutivePlanService;

public class ExecutivePlanCourseGroupServiceImpl
extends BaseServiceImpl
implements ExecutivePlanCourseGroupService {
    private ExecutivePlanService executePlanService;
    private PlanCourseGroupCommonDao planCourseGroupCommonDao;

    @Override
    public void removeCourseGroup(Long groupId) {
        ExecutiveCourseGroup group = (ExecutiveCourseGroup)this.entityDao.get(ExecutiveCourseGroup.class, (Serializable)groupId);
        this.removeCourseGroup(group);
    }

    @Override
    public void removeCourseGroup(ExecutiveCourseGroup group) {
        this.planCourseGroupCommonDao.removeCourseGroup(group);
    }

    public ExecutivePlanService getExecutivePlanService() {
        return this.executePlanService;
    }

    @Override
    public void saveOrUpdateCourseGroup(ExecutiveCourseGroup group) {
        this.planCourseGroupCommonDao.saveOrUpdateCourseGroup(group);
    }

    @Override
    public void courseGroupMoveDown(ExecutiveCourseGroup courseGroup) {
        this.planCourseGroupCommonDao.updateCourseGroupMoveDown(courseGroup);
    }

    @Override
    public void courseGroupMoveUp(ExecutiveCourseGroup courseGroup) {
        this.planCourseGroupCommonDao.updateCourseGroupMoveUp(courseGroup);
    }

    public void setExecutivePlanService(ExecutivePlanService executePlanService) {
        this.executePlanService = executePlanService;
    }

    public void setPlanCourseGroupCommonDao(PlanCourseGroupCommonDao planCourseGroupCommonDao) {
        this.planCourseGroupCommonDao = planCourseGroupCommonDao;
    }

    @Override
    public void move(CourseGroup node, CourseGroup location, int index) {
        if (Objects.equals((Object)node.getParent(), (Object)location)) {
            if (Numbers.toInt((String)node.getIndexno()) != index) {
                this.shiftCode(node, location, index);
            }
        } else {
            if (null != node.getParent()) {
                node.getParent().getChildren().remove(node);
            }
            node.setParent(location);
            this.shiftCode(node, location, index);
        }
    }

    private void shiftCode(CourseGroup node, CourseGroup newParent, int index) {
        List<CourseGroup> sibling = null;
        if (null != newParent) {
            sibling = newParent.getChildren();
        } else {
            sibling = CollectUtils.newArrayList();
            for (CourseGroup m : node.getPlan().getTopCourseGroups()) {
                if (null != m.getParent()) continue;
                sibling.add(m);
            }
        }
        Collections.sort(sibling);
        sibling.remove(node);
        if (--index > sibling.size()) {
            index = sibling.size();
        }
        sibling.add(index, node);
        int nolength = String.valueOf(sibling.size()).length();
        Set nodes = CollectUtils.newHashSet();
        for (int seqno = 1; seqno <= sibling.size(); ++seqno) {
            CourseGroup one = sibling.get(seqno - 1);
            this.generateCode(one, Strings.leftPad((String)String.valueOf(seqno), (int)nolength, (char)'0'), nodes);
        }
        this.entityDao.saveOrUpdate((Collection)nodes);
        this.entityDao.refresh((Object)node);
        this.entityDao.refresh((Object)node.getPlan());
    }

    public void genIndexno(CourseGroup group, String indexno) {
        if (null == group.getParent()) {
            group.setIndexno(indexno);
        } else if (StringUtils.isEmpty((CharSequence)indexno)) {
            group.setIndexno(Strings.concat((String[])new String[]{group.getParent().getIndexno(), ".", String.valueOf(group.getIndex())}));
        } else {
            group.setIndexno(Strings.concat((String[])new String[]{group.getParent().getIndexno(), ".", indexno}));
        }
    }

    private void generateCode(CourseGroup node, String indexno, Set<CourseGroup> nodes) {
        nodes.add(node);
        if (null != indexno) {
            this.genIndexno(node, indexno);
        } else {
            this.genIndexno(node, null);
        }
        if (null != node.getChildren()) {
            for (CourseGroup m : node.getChildren()) {
                this.generateCode(m, null, nodes);
            }
        }
    }

    @Override
    public boolean hasSameGroupInOneLevel(CourseGroup courseGroup, CoursePlan plan, CourseGroup parent) {
        OqlBuilder builder = OqlBuilder.from(ExecutiveCourseGroup.class, (String)"courseGroup");
        builder.where("courseGroup.courseType = :courseType", (Object)courseGroup.getCourseType());
        builder.where("courseGroup.plan = :plan", (Object)plan);
        if (courseGroup.isPersisted()) {
            builder.where("courseGroup.id <> :groupId", (Object)courseGroup.getId());
        }
        if (parent == null) {
            builder.where("courseGroup.parent is null");
        } else {
            builder.where("courseGroup.parent = :parent", (Object)parent);
        }
        return !this.entityDao.search((QueryBuilder)builder).isEmpty();
    }
}

