/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.edu.model;

import java.sql.Date;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.beangle.commons.entity.TemporalOn;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.edu.model.Major;
import org.openurp.code.edu.model.DisciplineCategory;

@Entity(name="org.openurp.base.edu.model.MajorDiscipline")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
public class MajorDiscipline
extends LongIdObject
implements TemporalOn {
    private static final long serialVersionUID = 3557919411080857215L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Major major;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private DisciplineCategory category;
    @NotNull
    private String disciplineCode;
    @NotNull
    private Date beginOn;
    private Date endOn;

    public boolean isMatchIn(Date d) {
        if (!this.beginOn.after(d)) {
            if (null == this.endOn) {
                return true;
            }
            return !d.after(this.endOn);
        }
        return false;
    }

    public Major getMajor() {
        return this.major;
    }

    public void setMajor(Major major) {
        this.major = major;
    }

    public DisciplineCategory getCategory() {
        return this.category;
    }

    public void setCategory(DisciplineCategory category) {
        this.category = category;
    }

    public String getDisciplineCode() {
        return this.disciplineCode;
    }

    public void setDisciplineCode(String disciplineCode) {
        this.disciplineCode = disciplineCode;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }
}

