/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.model;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzRestrictionItem;

@Entity(name="org.openurp.edu.clazz.model.ClazzRestriction")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
public class ClazzRestriction
extends LongIdObject
implements Cloneable {
    private static final long serialVersionUID = -6284931594985772061L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Clazz clazz;
    @OneToMany(mappedBy="restriction", orphanRemoval=true, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private List<ClazzRestrictionItem> items = CollectUtils.newArrayList();
    @NotNull
    private int maxCount;
    @NotNull
    private int curCount;
    private boolean prime = true;

    public List<ClazzRestrictionItem> getItems() {
        return this.items;
    }

    public void setItems(List<ClazzRestrictionItem> items) {
        this.items = items;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getCurCount() {
        return this.curCount;
    }

    public void setCurCount(int curCount) {
        this.curCount = curCount;
    }

    public Object clone() {
        try {
            ClazzRestriction clone = (ClazzRestriction)super.clone();
            clone.setId(null);
            clone.setClazz(null);
            clone.setItems(new ArrayList<ClazzRestrictionItem>());
            for (ClazzRestrictionItem item : this.getItems()) {
                ClazzRestrictionItem clone_item = (ClazzRestrictionItem)item.clone();
                clone_item.setRestriction(clone);
                clone.getItems().add(clone_item);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public void setClazz(Clazz clazz) {
        this.clazz = clazz;
    }

    public boolean isPrime() {
        return this.prime;
    }

    public void setPrime(boolean prime) {
        this.prime = prime;
    }
}

