/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.Component;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseAbilityRate;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzRestriction;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.clazz.model.Subclazz;
import org.openurp.edu.clazz.util.GenderRatio;

@Embeddable
public class Enrollment
implements Component,
Cloneable,
Serializable {
    private static final long serialVersionUID = 895173901324223302L;
    private String grades;
    @NotNull
    @Type(type="org.openurp.edu.clazz.util.GenderRatioType")
    private GenderRatio genderRatio = GenderRatio.empty;
    @ManyToOne(fetch=FetchType.LAZY)
    private Department depart;
    @NotNull
    private int stdCount;
    private int capacity;
    private boolean capacityLocked;
    private int reservedCount;
    @OneToMany(mappedBy="clazz", cascade={CascadeType.ALL})
    private Set<CourseTaker> courseTakers = new HashSet<CourseTaker>();
    @OneToMany(mappedBy="clazz", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Subclazz> subclazzes = new ArrayList<Subclazz>();
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private List<CourseAbilityRate> abilityRates = new ArrayList<CourseAbilityRate>();
    @OneToMany(mappedBy="clazz", orphanRemoval=true, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    @OrderBy(value="id")
    private List<ClazzRestriction> restrictions = CollectUtils.newArrayList();

    public Enrollment clone() {
        try {
            Enrollment clone = (Enrollment)super.clone();
            clone.setRestrictions(new ArrayList<ClazzRestriction>());
            for (ClazzRestriction group : this.getRestrictions()) {
                ClazzRestriction clone_group = (ClazzRestriction)group.clone();
                clone.getRestrictions().add(clone_group);
            }
            clone.setCourseTakers(new HashSet<CourseTaker>());
            for (CourseTaker taker : this.getCourseTakers()) {
                CourseTaker clone_taker = (CourseTaker)taker.clone();
                clone.getCourseTakers().add(clone_taker);
            }
            clone.setSubclazzes(new ArrayList<Subclazz>());
            clone.setAbilityRates(new ArrayList<CourseAbilityRate>(this.getAbilityRates()));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public CourseTaker getCourseTaker(Long stdId) {
        for (CourseTaker taker : this.getCourseTakers()) {
            if (!((Long)taker.getStd().getId()).equals(stdId)) continue;
            return taker;
        }
        return null;
    }

    public Set<CourseTaker> getNormalCourseTakers() {
        Set normalTakers = CollectUtils.newHashSet();
        if (CollectUtils.isNotEmpty(this.courseTakers)) {
            for (CourseTaker courseTaker : this.courseTakers) {
                if (courseTaker.isFreeListening()) continue;
                normalTakers.add(courseTaker);
            }
        }
        return normalTakers;
    }

    public void addLimitGroups(Clazz clazz, List<ClazzRestriction> groups) {
        for (ClazzRestriction group : groups) {
            group.setClazz(clazz);
            this.restrictions.add(group);
        }
    }

    public void addLimitGroups(Clazz clazz, ClazzRestriction ... groups) {
        for (ClazzRestriction group : groups) {
            group.setClazz(clazz);
            this.restrictions.add(group);
        }
    }

    public ClazzRestriction getOrCreateDefautRestriction() {
        for (ClazzRestriction limitGroup : this.restrictions) {
            if (!limitGroup.isPrime()) continue;
            return limitGroup;
        }
        ClazzRestriction forClassGroup = new ClazzRestriction();
        forClassGroup.setPrime(true);
        this.getRestrictions().add(forClassGroup);
        return forClassGroup;
    }

    public CourseTaker getCourseTaker(Student std) {
        return this.getCourseTaker((Long)std.getId());
    }

    public Set<CourseTaker> getCourseTakers() {
        return this.courseTakers;
    }

    public void setCourseTakers(Set<CourseTaker> courseTakers) {
        this.courseTakers = courseTakers;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int limitCount) {
        this.capacity = limitCount;
    }

    public String getGrades() {
        return this.grades;
    }

    public void setGrades(String year) {
        this.grades = year;
    }

    public Department getDepart() {
        return this.depart;
    }

    public void setDepart(Department depart) {
        this.depart = depart;
    }

    public List<ClazzRestriction> getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(List<ClazzRestriction> limitGroups) {
        this.restrictions = limitGroups;
    }

    public GenderRatio getGenderRatio() {
        return this.genderRatio;
    }

    public void setGenderRatio(GenderRatio genderRatio) {
        this.genderRatio = genderRatio;
    }

    public List<CourseAbilityRate> getAbilityRates() {
        return this.abilityRates;
    }

    public void setAbilityRates(List<CourseAbilityRate> abilityRates) {
        this.abilityRates = abilityRates;
    }

    public int getStdCount() {
        return this.stdCount;
    }

    public void setStdCount(int stdCount) {
        this.stdCount = stdCount;
    }

    public boolean isCapacityLocked() {
        return this.capacityLocked;
    }

    public void setCapacityLocked(boolean capacityLocked) {
        this.capacityLocked = capacityLocked;
    }

    public int getReservedCount() {
        return this.reservedCount;
    }

    public void setReservedCount(int reservedCount) {
        this.reservedCount = reservedCount;
    }

    public List<Subclazz> getSubclazzes() {
        return this.subclazzes;
    }

    public void setSubclazzes(List<Subclazz> subclazzes) {
        this.subclazzes = subclazzes;
    }
}

