/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service;

import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.code.edu.model.GradeType;
import org.openurp.edu.grade.Grade;
import org.openurp.edu.grade.course.model.CourseGrade;

public class CourseGradeComparator
implements Comparator<Object> {
    String cmpWhat;
    boolean isAsc;
    Map<String, GradeType> gradeTypeMap;

    public CourseGradeComparator(String cmpWhat, boolean isAsc, List<GradeType> gradeTypes) {
        this.cmpWhat = cmpWhat;
        this.isAsc = isAsc;
        this.gradeTypeMap = CollectUtils.newHashMap();
        for (GradeType gradeType : gradeTypes) {
            this.gradeTypeMap.put(((Integer)gradeType.getId()).toString(), gradeType);
        }
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        CourseGrade g0 = (CourseGrade)arg0;
        CourseGrade g1 = (CourseGrade)arg1;
        if (this.cmpWhat.startsWith("gradeType")) {
            String cmp = this.cmpWhat.substring(this.cmpWhat.indexOf(".") + 1);
            GradeType gradeType = this.gradeTypeMap.get(cmp);
            Grade eg0 = g0.getGrade(gradeType);
            Grade eg1 = g1.getGrade(gradeType);
            return this.cmpScore(null == eg0 ? null : eg0.getScore(), eg1 == null ? null : eg1.getScore(), this.isAsc);
        }
        try {
            Collator myCollator = Collator.getInstance();
            Object what0 = PropertyUtils.getProperty((Object)arg0, (String)this.cmpWhat);
            Object what1 = PropertyUtils.getProperty((Object)arg1, (String)this.cmpWhat);
            if (this.isAsc) {
                return myCollator.compare(null == what0 ? "" : what0.toString(), null == what1 ? "" : what1.toString());
            }
            return myCollator.compare(null == what1 ? "" : what1.toString(), null == what0 ? "" : what0.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("[CourseGradeComparator]reflection error:" + this.cmpWhat + e.getMessage());
        }
    }

    private int cmpScore(Float score0, Float score1, boolean isAsc) {
        float fs1;
        float fs0 = null == score0 ? 0.0f : score0.floatValue();
        float f = fs1 = null == score1 ? 0.0f : score1.floatValue();
        if (isAsc) {
            return Float.compare(fs0, fs1);
        }
        return Float.compare(fs1, fs0);
    }
}

