/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;
import javax.validation.constraints.NotNull;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.Program;

@MappedSuperclass
public abstract class AbstractCoursePlan
extends LongIdObject
implements CoursePlan {
    private static final long serialVersionUID = 1606351182470625309L;
    @NotNull
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Program program;
    @NotNull
    private float credits;
    private int creditHours;
    private String hourRatios;
    private Date updatedAt;

    @Override
    public float getCredits() {
        return this.credits;
    }

    @Override
    public void setCredits(float credits) {
        this.credits = credits;
    }

    public int getEndTerm() {
        return this.program.getEndTerm();
    }

    public int getStartTerm() {
        return this.program.getStartTerm();
    }

    public int getTermsCount() {
        return this.getEndTerm() - this.getStartTerm() + 1;
    }

    public void addGroup(CourseGroup group) {
        if (null == this.getGroups()) {
            this.setGroups(new ArrayList());
        }
        this.getGroups().add(group);
        group.updateCoursePlan(this);
    }

    @Override
    public List<CourseGroup> getTopCourseGroups() {
        if (this.getGroups() == null) {
            return new ArrayList<CourseGroup>();
        }
        ArrayList<CourseGroup> res = new ArrayList<CourseGroup>();
        for (CourseGroup group : this.getGroups()) {
            if (group == null || group.getParent() != null) continue;
            res.add(group);
        }
        return res;
    }

    @Override
    public CourseGroup getGroup(CourseType type) {
        if (null == this.getGroups()) {
            return null;
        }
        for (CourseGroup group : this.getGroups()) {
            if (!group.getCourseType().equals((Object)type)) continue;
            return group;
        }
        return null;
    }

    public boolean isNumericTerm() {
        return true;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    @Override
    public java.sql.Date getBeginOn() {
        return this.program.getBeginOn();
    }

    @Override
    public java.sql.Date getEndOn() {
        return this.program.getEndOn();
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public int getCreditHours() {
        return this.creditHours;
    }

    public void setCreditHours(int creditHours) {
        this.creditHours = creditHours;
    }

    public String getHourRatios() {
        return this.hourRatios;
    }

    public void setHourRatios(String hourRatios) {
        this.hourRatios = hourRatios;
    }
}

