/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.dao.hibernate;

import java.util.List;
import org.apache.commons.lang3.Range;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.orm.hibernate.HibernateEntityDao;
import org.openurp.base.edu.model.Major;
import org.openurp.base.service.SemesterService;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.edu.program.model.ExecutivePlan;
import org.openurp.edu.program.plan.dao.ExecutivePlanCourseGroupDao;
import org.openurp.edu.program.plan.dao.ExecutivePlanDao;

public class ExecutivePlanDaoHibernate
extends HibernateEntityDao
implements ExecutivePlanDao {
    protected SemesterService semesterService;
    protected ExecutivePlanCourseGroupDao executePlanCourseGroupDao;

    @Override
    public List<ExecutivePlan> getExecutivePlanList(String grade, Major major, EducationLevel level) {
        OqlBuilder query = OqlBuilder.from(ExecutivePlan.class, (String)"plan");
        query.where("plan.program.grade=:grade", (Object)grade).where("plan.program.major=:major", (Object)major).where("plan.program.level=:level", (Object)level);
        return this.search((QueryBuilder)query);
    }

    protected ExecutivePlan getExecutivePlan(Long id) {
        return (ExecutivePlan)this.get(ExecutivePlan.class, id);
    }

    @Override
    public List<ExecutivePlan> getExecutivePlans(Long[] planIds) {
        OqlBuilder query = OqlBuilder.from(ExecutivePlan.class, (String)"plan");
        query.where("plan.id in (:ids)", (Object)planIds);
        return this.search((QueryBuilder)query);
    }

    public Float getCreditByTerm(ExecutivePlan plan, int term) {
        Range termRange = Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(plan.getProgram().getTermsCount()));
        if (!termRange.contains((Object)term)) {
            throw new RuntimeException("term out range");
        }
        return null;
    }

    public void setExecutivePlanCourseGroupDao(ExecutivePlanCourseGroupDao executePlanCourseGroupDao) {
        this.executePlanCourseGroupDao = executePlanCourseGroupDao;
    }

    public void setSemesterService(SemesterService semesterService) {
        this.semesterService = semesterService;
    }
}

