/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.service.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.metadata.Model;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.tuple.Pair;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzRestriction;
import org.openurp.edu.clazz.model.ClazzRestrictionItem;
import org.openurp.edu.clazz.model.ClazzRestrictionMeta;
import org.openurp.edu.clazz.model.Enrollment;
import org.openurp.edu.clazz.service.ClazzNameStrategy;
import org.openurp.edu.clazz.service.limit.RestrictionItemContentProvider;
import org.openurp.edu.clazz.service.limit.RestrictionItemContentProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTeachClassNameStrategy
implements ClazzNameStrategy {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Integer nameMaxSize;
    private String delimeter = " ";
    private RestrictionItemContentProviderFactory courseLimitItemContentProviderFactory;

    @Override
    public String genName(List<ClazzRestriction> groups) {
        return Strings.abbreviate((String)((String)this.buildAll(groups).getLeft()), (int)this.getNameMaxSize());
    }

    @Override
    public String genName(Clazz clazz) {
        return this.genName(clazz.getEnrollment().getRestrictions());
    }

    @Override
    public String genName(String fullname) {
        if (Strings.isBlank((CharSequence)fullname)) {
            return fullname;
        }
        return Strings.abbreviate((String)fullname, (int)this.getNameMaxSize());
    }

    @Override
    public void autoName(Clazz clazz) {
        Enrollment teachclass = clazz.getEnrollment();
        Pair<String, String> names = this.buildAll(teachclass.getRestrictions());
        clazz.setClazzName((String)names.getLeft());
        if (clazz.getEnrollment().getRestrictions().isEmpty() && null != clazz.getEnrollment().getGrades()) {
            clazz.setClazzName(teachclass.getGrades() + (String)names.getLeft());
        }
        if (null != teachclass.getGenderRatio() && !teachclass.getGenderRatio().isEmpty()) {
            if (teachclass.getGenderRatio().isAllMale()) {
                if (!clazz.getClazzName().contains("\u7537")) {
                    clazz.setClazzName(clazz.getClazzName() + "\u7537");
                }
            } else if (teachclass.getGenderRatio().isAllFemale() && !clazz.getClazzName().contains("\u5973")) {
                clazz.setClazzName(clazz.getClazzName() + "\u5973");
            }
        }
    }

    private Pair<String, String> buildAll(List<ClazzRestriction> groups) {
        Map providers = CollectUtils.newHashMap();
        List groupContentTitles = CollectUtils.newArrayList();
        Map excludeContents = CollectUtils.newHashMap();
        for (ClazzRestriction restriction : groups) {
            Map metaContentTitles = CollectUtils.newHashMap();
            for (ClazzRestrictionItem clazzRestrictionItem : restriction.getItems()) {
                boolean exclude = !clazzRestrictionItem.isIncluded();
                ClazzRestrictionMeta meta = clazzRestrictionItem.getMeta();
                RestrictionItemContentProvider<?> provider = (RestrictionItemContentProvider<?>)providers.get((Object)meta);
                if (null == provider) {
                    provider = this.courseLimitItemContentProviderFactory.getProvider(meta);
                    providers.put(meta, provider);
                }
                Iterator contentIdTitles = provider.getContentIdTitleMap(clazzRestrictionItem.getContents());
                LinkedHashSet<String> contentTitles = new LinkedHashSet<String>(contentIdTitles.values());
                if (exclude) {
                    List oneMetaExcludeContents = (List)excludeContents.get((Object)meta);
                    if (null == oneMetaExcludeContents) {
                        oneMetaExcludeContents = CollectUtils.newArrayList();
                        excludeContents.put(meta, oneMetaExcludeContents);
                    }
                    oneMetaExcludeContents.add(contentTitles);
                }
                metaContentTitles.put(meta, new Pair((Object)clazzRestrictionItem.isIncluded(), contentTitles));
            }
            groupContentTitles.add(metaContentTitles);
        }
        for (Map oneGroupContentTitles : groupContentTitles) {
            for (Map.Entry entry : oneGroupContentTitles.entrySet()) {
                ClazzRestrictionMeta clazzRestrictionMeta = (ClazzRestrictionMeta)((Object)entry.getKey());
                Boolean op = (Boolean)((Pair)entry.getValue()).getLeft();
                if (!op.booleanValue()) continue;
                Set contents = (Set)((Pair)entry.getValue()).getRight();
                List oneMetaExcludeContents = (List)excludeContents.get((Object)clazzRestrictionMeta);
                if (null == oneMetaExcludeContents) continue;
                for (Set oneMetaExcludeContentSet : oneMetaExcludeContents) {
                    oneMetaExcludeContentSet.removeAll(contents);
                }
            }
        }
        StringBuilder fullNameBuilder = new StringBuilder();
        StringBuilder nameBuilder = new StringBuilder();
        ClazzRestrictionMeta[] enums = ClazzRestrictionMeta.values();
        Map map = CollectUtils.newHashMap();
        for (ClazzRestrictionMeta courseLimitMetaEnum : enums) {
            map.put(courseLimitMetaEnum, courseLimitMetaEnum);
        }
        Map map2 = CollectUtils.newHashMap();
        map2.put(ClazzRestrictionMeta.Squad, "\u73ed\u7ea7");
        map2.put(ClazzRestrictionMeta.Department, "\u9662\u7cfb");
        map2.put(ClazzRestrictionMeta.Direction, "\u65b9\u5411");
        map2.put(ClazzRestrictionMeta.Level, "\u57f9\u517b\u5c42\u6b21");
        map2.put(ClazzRestrictionMeta.Gender, "\u6027\u522b");
        map2.put(ClazzRestrictionMeta.Grade, "\u5e74\u7ea7");
        map2.put(ClazzRestrictionMeta.Major, "\u4e13\u4e1a");
        map2.put(ClazzRestrictionMeta.StdType, "\u5b66\u751f\u7c7b\u522b");
        for (Map oneGroupContentTitles : groupContentTitles) {
            boolean isEmptyGroup = true;
            for (Map.Entry entry : oneGroupContentTitles.entrySet()) {
                ClazzRestrictionMeta meta = (ClazzRestrictionMeta)((Object)entry.getKey());
                ClazzRestrictionMeta metaEnum = (ClazzRestrictionMeta)((Object)map.get((Object)meta));
                int length = fullNameBuilder.length();
                if (ClazzRestrictionMeta.Grade.equals((Object)metaEnum)) {
                    this.appendGradeContents(fullNameBuilder, oneGroupContentTitles);
                } else {
                    this.appendEntityContents(fullNameBuilder, metaEnum, oneGroupContentTitles, (String)map2.get((Object)metaEnum));
                }
                isEmptyGroup = length == fullNameBuilder.length();
            }
            if (!isEmptyGroup) {
                fullNameBuilder.append(this.delimeter);
            }
            StringBuilder sb = new StringBuilder();
            this.appendEntityContents(sb, ClazzRestrictionMeta.Squad, oneGroupContentTitles, "\u73ed\u7ea7");
            if (sb.length() == 0) {
                this.appendGradeContents(sb, oneGroupContentTitles);
                boolean containsMajor = this.containsMeta(ClazzRestrictionMeta.Major, oneGroupContentTitles);
                if (containsMajor) {
                    this.appendEntityContents(sb, ClazzRestrictionMeta.Major, oneGroupContentTitles, "\u4e13\u4e1a");
                } else {
                    this.appendEntityContents(sb, ClazzRestrictionMeta.Department, oneGroupContentTitles, "\u9662\u7cfb");
                }
                this.appendEntityContents(sb, ClazzRestrictionMeta.StdType, oneGroupContentTitles, "\u65b9\u5411");
            }
            if (sb.length() <= 0) continue;
            if (nameBuilder.length() > 0) {
                nameBuilder.append(this.delimeter);
            }
            nameBuilder.append(sb.toString());
        }
        if (nameBuilder.length() == 0) {
            nameBuilder.append("\u5168\u6821");
        }
        String name = nameBuilder.toString();
        String fullname = "\u5168\u6821";
        if (fullNameBuilder.length() > 0) {
            fullname = fullNameBuilder.substring(0, fullNameBuilder.length() - 1);
        }
        return new Pair((Object)name, (Object)fullname);
    }

    private boolean containsMeta(ClazzRestrictionMeta meta, Map<ClazzRestrictionMeta, Pair<Boolean, Set<String>>> groupContents) {
        Pair<Boolean, Set<String>> pair = groupContents.get((Object)meta);
        if (null != pair) {
            return CollectUtils.isNotEmpty((Collection)((Collection)pair.getRight()));
        }
        return false;
    }

    private StringBuilder appendEntityContents(StringBuilder sb, ClazzRestrictionMeta meta, Map<ClazzRestrictionMeta, Pair<Boolean, Set<String>>> oneGroupContentTitles, String key) {
        Set contents;
        Pair<Boolean, Set<String>> directionPair = oneGroupContentTitles.get((Object)meta);
        if (null != directionPair && CollectUtils.isNotEmpty((Collection)(contents = (Set)directionPair.getRight()))) {
            Boolean directionOp;
            if (sb.length() > 0) {
                sb.append(",");
            }
            if (!(directionOp = (Boolean)directionPair.getLeft()).booleanValue()) {
                sb.append("\u975e ");
            }
            sb.append(Strings.join((String[])contents.toArray(new String[contents.size()]), (String)" "));
        }
        return sb;
    }

    private StringBuilder appendGradeContents(StringBuilder sb, Map<ClazzRestrictionMeta, Pair<Boolean, Set<String>>> oneGroupContentTitles) {
        Pair<Boolean, Set<String>> gradePair = oneGroupContentTitles.get((Object)ClazzRestrictionMeta.Grade);
        if (null != gradePair && CollectUtils.isNotEmpty((Collection)((Collection)gradePair.getRight()))) {
            Boolean gradeOp;
            if (sb.length() > 0) {
                sb.append(",");
            }
            if (!(gradeOp = (Boolean)gradePair.getLeft()).booleanValue()) {
                sb.append("\u975e ");
            }
            for (String grade : (Set)gradePair.getRight()) {
                sb.append(grade).append("\u7ea7 ");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    private int getNameMaxSize() {
        if (null == nameMaxSize) {
            nameMaxSize = 100;
            Class entityClass = Model.getType(Clazz.class).getEntityClass();
            try {
                nameMaxSize = entityClass.getDeclaredField("name").getAnnotation(Size.class).max();
            }
            catch (NoSuchFieldException e) {
                this.logger.info("get " + entityClass.getName() + ".name max size failure", (Throwable)e);
            }
            catch (SecurityException e) {
                this.logger.info("get " + entityClass.getName() + ".name max size failure", (Throwable)e);
            }
        }
        return nameMaxSize;
    }

    public void setRestrictionItemContentProviderFactory(RestrictionItemContentProviderFactory courseLimitItemContentProviderFactory) {
        this.courseLimitItemContentProviderFactory = courseLimitItemContentProviderFactory;
    }
}

