/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.text.i18n.TextResource;
import org.beangle.commons.transfer.exporter.DefaultPropertyExtractor;
import org.openurp.base.hr.model.Teacher;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.grade.course.model.CourseGradeState;

public class GradeStatExtractor
extends DefaultPropertyExtractor {
    public GradeStatExtractor(TextResource textResource) {
        super(textResource);
    }

    public Object getPropertyValue(Object target, String property) throws Exception {
        if ("teachers".equals(property)) {
            Object teacherName = "";
            List<Teacher> teachers = CollectUtils.newArrayList();
            if (target instanceof Clazz) {
                Clazz clazz = (Clazz)target;
                teachers = clazz.getTeachers();
            } else {
                CourseGradeState gradeState = (CourseGradeState)target;
                teachers = gradeState.getClazz().getTeachers();
            }
            if (teachers.size() == 0) {
                return "\u672a\u5b89\u6392\u6559\u5e08";
            }
            for (int i = 0; i < teachers.size(); ++i) {
                if (i > 0) {
                    teacherName = (String)teacherName + ",";
                }
                teacherName = (String)teacherName + teachers.get(i).getName();
            }
            return teacherName;
        }
        return super.getPropertyValue(target, property);
    }
}

