/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.app.model;

import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import org.apache.commons.beanutils.PropertyUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.commons.lang.Objects;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.Throwables;
import org.hibernate.annotations.Type;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.Department;
import org.openurp.base.time.Terms;
import org.openurp.edu.program.app.model.ExecutivePlanCourseModify;
import org.openurp.edu.program.app.model.FakeCourseGroup;
import org.openurp.edu.program.model.ExecutiveCourseGroup;
import org.openurp.edu.program.model.ExecutivePlanCourse;
import org.openurp.edu.program.model.PlanCourse;

@MappedSuperclass
public abstract class ExecutivePlanCourseModifyDetail
extends LongIdObject
implements Comparable,
Cloneable {
    private static final long serialVersionUID = 5552733977609925991L;
    @ManyToOne(fetch=FetchType.LAZY)
    protected Course course;
    @ManyToOne(fetch=FetchType.LAZY)
    protected Department department;
    @Type(type="org.openurp.base.time.hibernate.TermsType")
    protected Terms terms;
    protected boolean compulsory;
    protected FakeCourseGroup fakeCourseGroup;
    protected String remark;

    public boolean isSame(Object object) {
        if (!(object instanceof PlanCourse)) {
            return false;
        }
        ExecutivePlanCourse rhs = (ExecutivePlanCourse)object;
        return Objects.equalsBuilder().add((Object)this.getTerms(), (Object)rhs.getTerms()).add((Object)this.getRemark(), (Object)rhs.getRemark()).add((Object)this.getCourse().getId(), (Object)rhs.getCourse().getId()).add((Object)this.getId(), (Object)rhs.getId()).isEquals();
    }

    public int compareTo(Object object) {
        PlanCourse myClass = (PlanCourse)object;
        return Objects.compareBuilder().add(this.getCourse().getDefaultCredits(), myClass.getCourse().getDefaultCredits()).toComparison();
    }

    public Object clone() {
        ExecutivePlanCourse planCourse = new ExecutivePlanCourse();
        try {
            PropertyUtils.copyProperties((Object)planCourse, (Object)this);
            planCourse.setGroup(null);
            planCourse.setId(null);
        }
        catch (Exception e) {
            throw new RuntimeException("error in clone planCourse:" + Throwables.getStackTrace((Throwable)e));
        }
        return planCourse;
    }

    public boolean inTerm(String terms) {
        if (Strings.isEmpty((CharSequence)terms)) {
            return true;
        }
        String[] termArray = Strings.split((String)terms, (String)",");
        for (int i = 0; i < termArray.length; ++i) {
            if (!Strings.contains((CharSequence)("," + String.valueOf(this.getTerms()) + ","), (CharSequence)("," + termArray[i] + ","))) continue;
            return true;
        }
        return false;
    }

    public Course getCourse() {
        return this.course;
    }

    public void setCourse(Course course) {
        this.course = course;
    }

    public FakeCourseGroup getFakeCourseGroup() {
        return this.fakeCourseGroup;
    }

    public void setFakeCourseGroup(FakeCourseGroup fakeCourseGroup) {
        this.fakeCourseGroup = fakeCourseGroup;
    }

    public void setFakeCourseGroupByReal(ExecutiveCourseGroup courseGroup) {
        if (this.fakeCourseGroup == null) {
            this.fakeCourseGroup = new FakeCourseGroup();
        }
        this.fakeCourseGroup.setId((Long)courseGroup.getId());
        this.fakeCourseGroup.setCourseType(courseGroup.getCourseType());
    }

    public String getRemark() {
        return this.remark;
    }

    public Terms getTerms() {
        return this.terms;
    }

    public void setTerms(Terms terms) {
        this.terms = terms;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public boolean isCompulsory() {
        return this.compulsory;
    }

    public void setCompulsory(boolean compulsory) {
        this.compulsory = compulsory;
    }

    public abstract ExecutivePlanCourseModify getApply();

    public abstract void setApply(ExecutivePlanCourseModify var1);
}

