/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.service.impl;

import java.util.List;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.std.model.Student;
import org.openurp.edu.program.model.AlternativeCourse;
import org.openurp.edu.program.model.MajorAlternativeCourse;
import org.openurp.edu.program.model.StdAlternativeCourse;
import org.openurp.edu.program.plan.service.AlternativeCourseService;

public class AlternativeCourseServiceImpl
extends BaseServiceImpl
implements AlternativeCourseService {
    @Override
    public List<AlternativeCourse> getAlternativeCourses(Student student) {
        List<AlternativeCourse> substituteList = this.getStdAlternativeCourses(student);
        substituteList.addAll(this.getMajorAlternativeCourses(student));
        return substituteList;
    }

    @Override
    public List<StdAlternativeCourse> getStdAlternativeCourses(Student student) {
        OqlBuilder query = OqlBuilder.from(StdAlternativeCourse.class, (String)"alternative");
        query.where("alternative.std=:std", (Object)student);
        return this.entityDao.search((QueryBuilder)query);
    }

    @Override
    public List<MajorAlternativeCourse> getMajorAlternativeCourses(Student student) {
        OqlBuilder query = OqlBuilder.from(MajorAlternativeCourse.class, (String)"alternative");
        query.where(":grade between alternative.fromGrade.code and alternative.toGrade.code", (Object)student.getGrade().getCode());
        query.where("alternative.project = :project", (Object)student.getProject());
        query.where("alternative.stdType is null or alternative.stdType = :stdType", (Object)student.getStdType());
        if (null == student.getMajor()) {
            query.where("alternative.major is null");
        } else {
            query.where("alternative.major is null or alternative.major = :major", (Object)student.getMajor());
        }
        if (null == student.getDirection()) {
            query.where("alternative.direction is null");
        } else {
            query.where("alternative.direction is null or alternative.direction = :direction", (Object)student.getDirection());
        }
        return this.entityDao.search((QueryBuilder)query);
    }
}

