/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.code.service.impl;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.entity.pojo.Code;
import org.beangle.ems.dictionary.model.CodeMeta;
import org.openurp.code.service.CodeService;

public class CodeServiceImpl
extends BaseServiceImpl
implements CodeService {
    @Override
    public <T extends Code<Integer>> T getCode(Class<T> codeClass, String code) {
        OqlBuilder builder = OqlBuilder.from(codeClass, (String)"basecode").where("basecode.code=:code", (Object)code);
        List rs = this.entityDao.search((QueryBuilder)builder);
        if (!rs.isEmpty()) {
            return (T)((Code)rs.get(0));
        }
        return null;
    }

    @Override
    public <T extends Code<Integer>> List<T> getCodes(Class<T> codeClass) {
        java.sql.Date now = java.sql.Date.valueOf(LocalDate.now());
        OqlBuilder builder = OqlBuilder.from(codeClass, (String)"basecode").where("basecode.beginOn <= :now and (basecode.endOn is null or basecode.endOn >= :now)", (Object)now);
        builder.orderBy("basecode.code").cacheable();
        return this.entityDao.search((QueryBuilder)builder);
    }

    @Override
    public <T extends Code<Integer>> T getCode(Class<T> codeClass, Integer codeId) {
        return (T)((Code)this.entityDao.get(codeClass, (Serializable)codeId));
    }

    @Override
    public <T extends Code<Integer>> List<T> getCodes(Class<T> type, Integer ... ids) {
        OqlBuilder builder = OqlBuilder.from(type, (String)"basecode").where("basecode.id in(:ids)", (Object)ids);
        return this.entityDao.search((QueryBuilder)builder);
    }

    @Override
    public Class<? extends Code<Integer>> getCodeType(String name) {
        OqlBuilder builder = OqlBuilder.from(CodeMeta.class, (String)"coder");
        builder.where("coder.name=:name or coder.enName=:name", (Object)name);
        List coders = this.entityDao.search((QueryBuilder)builder);
        try {
            if (1 != coders.size()) {
                return null;
            }
            return Class.forName(((CodeMeta)coders.get(0)).getClassName());
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Basecode " + name + "stdType not found", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeCodes(Class<? extends Code<Integer>> codeClass, Integer ... codeIds) {
        this.entityDao.remove((Collection)this.entityDao.get(codeClass, (Serializable[])codeIds));
    }

    @Override
    public void saveOrUpdate(Code<Integer> code) {
        code.setUpdatedAt((Date)new java.sql.Date(System.currentTimeMillis()));
        this.entityDao.saveOrUpdate(new Object[]{code});
    }
}

