/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.app.model.constraint;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.openurp.base.edu.model.Semester;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.clazz.app.model.CourseTypeCreditConstraint;
import org.openurp.edu.clazz.app.model.constraint.StdCourseCountConstraint;
import org.openurp.edu.clazz.app.model.constraint.StdCreditConstraint;
import org.openurp.edu.clazz.app.model.constraint.StdTotalCreditConstraint;
import org.openurp.edu.clazz.app.model.enums.ConstraintType;

@Entity(name="org.openurp.edu.clazz.app.model.constraint.ConstraintLogger")
public class ConstraintLogger
extends LongIdObject {
    private static final long serialVersionUID = -3518168114908289841L;
    @ManyToOne(fetch=FetchType.LAZY)
    private Semester semester;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private ConstraintType constraintType;
    @NotNull
    @Size(max=30)
    private String type;
    @NotNull
    private String key;
    private String value;
    @NotNull
    private Date createdAt;
    @NotNull
    private String operator;

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public String getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public static ConstraintLogger genLogger(StdCreditConstraint constraint, String type) {
        ConstraintLogger logger = new ConstraintLogger();
        logger.constraintType = ConstraintType.stdCreditConstraint;
        StringBuilder sb = new StringBuilder();
        sb.append(constraint.getSemester().getSchoolYear()).append(constraint.getSemester().getName());
        sb.append(",").append(constraint.getStd().getCode());
        logger.semester = constraint.getSemester();
        logger.key = sb.toString();
        logger.value = null == constraint.getMaxCredit() ? null : constraint.getMaxCredit().toString();
        logger.type = type;
        return logger;
    }

    public static ConstraintLogger genLogger(StdTotalCreditConstraint constraint, String type) {
        ConstraintLogger logger = new ConstraintLogger();
        logger.constraintType = ConstraintType.stdTotalCreditConstraint;
        logger.key = constraint.getStd().getCode();
        logger.value = null == constraint.getMaxCredit() ? null : constraint.getMaxCredit().toString();
        logger.type = type;
        return logger;
    }

    public static ConstraintLogger genLogger(CourseTypeCreditConstraint constraint, String type) {
        ConstraintLogger logger = new ConstraintLogger();
        logger.constraintType = ConstraintType.courseTypeCreditConstraint;
        StringBuilder sb = new StringBuilder();
        sb.append(constraint.getSemester().getSchoolYear()).append(constraint.getSemester().getName());
        sb.append(",[").append(constraint.getGrades()).append("],");
        sb.append(",").append(constraint.getLevel().getName());
        sb.append(",").append(constraint.getCourseType().getName()).append("(").append(constraint.getCourseType().getCode()).append("),");
        logger.semester = constraint.getSemester();
        logger.key = sb.toString();
        logger.value = "" + constraint.getLimitCredit();
        logger.type = type;
        return logger;
    }

    public static ConstraintLogger genLogger(StdCourseCountConstraint constraint, CourseType courseType, String type) {
        ConstraintLogger logger = new ConstraintLogger();
        logger.constraintType = ConstraintType.stdCourseCountConstraint;
        StringBuilder sb = new StringBuilder();
        sb.append(constraint.getSemester().getSchoolYear()).append(constraint.getSemester().getName());
        sb.append(",").append(constraint.getStd().getCode());
        if (null == courseType) {
            sb.append(",\u603b\u95e8\u6570\u4e0a\u9650");
            logger.value = null == constraint.getMaxCourseCount() ? null : "" + constraint.getMaxCourseCount();
        } else {
            sb.append(",").append(courseType.getName()).append("(").append(courseType.getCode()).append(")");
            Integer maxCourseCount = constraint.getCourseTypeMaxCourseCount().get((Object)courseType);
            logger.value = null == maxCourseCount ? null : "" + maxCourseCount;
        }
        logger.semester = constraint.getSemester();
        logger.key = sb.toString();
        logger.type = type;
        return logger;
    }

    public static ConstraintLogger genLogger(StdCourseCountConstraint constraint, String type) {
        return ConstraintLogger.genLogger(constraint, null, type);
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public void setConstraintType(ConstraintType constraintType) {
        this.constraintType = constraintType;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

