/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.util.Collections;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.script.ExpressionEvaluator;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.service.impl.GradeFilter;

public class ScriptGradeFilter
implements GradeFilter {
    String script;
    ExpressionEvaluator expressionEvaluator;

    public ScriptGradeFilter() {
    }

    public ScriptGradeFilter(String script, ExpressionEvaluator expressionEvaluator) {
        this.script = script;
        this.expressionEvaluator = expressionEvaluator;
    }

    @Override
    public List<CourseGrade> filter(List<CourseGrade> grades) {
        if (Strings.isEmpty((CharSequence)this.script)) {
            return grades;
        }
        List newGrades = CollectUtils.newArrayList();
        for (CourseGrade grade : grades) {
            Boolean rs = (Boolean)this.expressionEvaluator.eval(this.script, Collections.singletonMap("grade", grade), Boolean.class);
            if (!rs.booleanValue()) continue;
            newGrades.add(grade);
        }
        return newGrades;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    public String getScript() {
        return this.script;
    }
}

