/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Strings;
import org.openurp.edu.grade.course.service.impl.GradeFilter;
import org.openurp.edu.grade.course.service.impl.GradeFilterRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringGradeFilterRegistry
implements GradeFilterRegistry,
ApplicationContextAware,
InitializingBean {
    final Map<String, GradeFilter> filters = CollectUtils.newHashMap();
    ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (null == this.applicationContext) {
            return;
        }
        String[] names = this.applicationContext.getBeanNamesForType(GradeFilter.class);
        if (null != names && names.length > 0) {
            for (String name : names) {
                this.filters.put(name, (GradeFilter)this.applicationContext.getBean(name));
            }
        }
    }

    @Override
    public GradeFilter getFilter(String name) {
        return this.filters.get(name);
    }

    @Override
    public List<GradeFilter> getFilters(String name) {
        if (Strings.isBlank((CharSequence)name)) {
            return Collections.emptyList();
        }
        String[] filterNames = Strings.split((String)name, (char[])new char[]{'|', ','});
        List myFilters = CollectUtils.newArrayList();
        for (String filterName : filterNames) {
            GradeFilter filter = this.filters.get(filterName);
            if (null == filter) continue;
            myFilters.add(filter);
        }
        return myFilters;
    }
}

