/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.lang.functor.Transformer;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.plan.service.PlanCompareService;
import org.openurp.edu.program.plan.util.CourseTypeWrapper;
import org.openurp.edu.program.plan.util.PlanCourseWrapper;

public class PlanCompareServiceImpl
extends BaseServiceImpl
implements PlanCompareService {
    @Override
    public Map<String, List<? extends PlanCourse>[]> diff(CoursePlan leftPlan, CoursePlan rightPlan) {
        Collection<String> collection;
        Collection<String> collection2;
        HashMap<String, List<? extends PlanCourse>[]> result = new HashMap<String, List<? extends PlanCourse>[]>();
        List<CourseGroup> leftCourseGroups = leftPlan.getGroups();
        HashSet<CourseTypeWrapper> leftCourseTypes = new HashSet<CourseTypeWrapper>();
        for (CourseGroup courseGroup : leftCourseGroups) {
            leftCourseTypes.add(new CourseTypeWrapper(courseGroup.getName()));
        }
        List<CourseGroup> rightCourseGroups = rightPlan.getGroups();
        HashSet<CourseTypeWrapper> rightCourseTypes = new HashSet<CourseTypeWrapper>();
        for (CourseGroup courseGroup : rightCourseGroups) {
            rightCourseTypes.add(new CourseTypeWrapper(courseGroup.getName()));
        }
        Collection<String> onlyInLeftCourseTypes = this.unWrapCourseTypes(CollectionUtils.subtract(leftCourseTypes, rightCourseTypes));
        if (onlyInLeftCourseTypes.size() > 0) {
            for (String string : onlyInLeftCourseTypes) {
                result.put(string, null);
                ArrayList[] planCourses = new ArrayList[2];
                planCourses[0] = new ArrayList<PlanCourse>(PlanCompareServiceImpl.getGroup(leftPlan, string).getPlanCourses());
                Collections.sort(planCourses[0], PlanCourseWrapper.COMPARATOR);
                planCourses[1] = new ArrayList();
                result.put(string, planCourses);
            }
        }
        if ((collection2 = this.unWrapCourseTypes(CollectionUtils.subtract(rightCourseTypes, leftCourseTypes))).size() > 0) {
            for (String courseType : collection2) {
                result.put(courseType, null);
                ArrayList[] planCourses = new ArrayList[]{new ArrayList(), new ArrayList<PlanCourse>(PlanCompareServiceImpl.getGroup(rightPlan, courseType).getPlanCourses())};
                Collections.sort(planCourses[1], PlanCourseWrapper.COMPARATOR);
                result.put(courseType, planCourses);
            }
        }
        if ((collection = this.unWrapCourseTypes(CollectionUtils.intersection(leftCourseTypes, rightCourseTypes))).size() > 0) {
            for (String courseType : collection) {
                Collection<PlanCourseWrapper> wrappedLeftPlanCourses = this.wrapPlanCourses(PlanCompareServiceImpl.getGroup(leftPlan, courseType).getPlanCourses());
                Collection<PlanCourseWrapper> wrappedRightPlanCourses = this.wrapPlanCourses(PlanCompareServiceImpl.getGroup(rightPlan, courseType).getPlanCourses());
                Collection<PlanCourse> onlyInLeftPlanCourses = this.unWrapPlanCourses(CollectionUtils.subtract(wrappedLeftPlanCourses, wrappedRightPlanCourses));
                Collection<PlanCourse> onlyInRightPlanCourses = this.unWrapPlanCourses(CollectionUtils.subtract(wrappedRightPlanCourses, wrappedLeftPlanCourses));
                if (onlyInLeftPlanCourses.size() == 0 && onlyInRightPlanCourses.size() == 0) continue;
                result.put(courseType, null);
                ArrayList[] planCourses = new ArrayList[]{new ArrayList<PlanCourse>(onlyInLeftPlanCourses), new ArrayList<PlanCourse>(onlyInRightPlanCourses)};
                Collections.sort(planCourses[0], PlanCourseWrapper.COMPARATOR);
                Collections.sort(planCourses[1], PlanCourseWrapper.COMPARATOR);
                result.put(courseType, planCourses);
            }
        }
        return result;
    }

    public static CourseGroup getGroup(CoursePlan plan, String name) {
        if (null == plan.getGroups()) {
            return null;
        }
        for (CourseGroup group : plan.getGroups()) {
            if (!group.getName().equals(name)) continue;
            return group;
        }
        return null;
    }

    private Collection<PlanCourseWrapper> wrapPlanCourses(Collection<? extends PlanCourse> planCourses) {
        return CollectUtils.collect(planCourses, (Transformer)PlanCourseWrapper.WRAPPER);
    }

    private Collection<PlanCourse> unWrapPlanCourses(Collection<PlanCourseWrapper> planCourseWrappers) {
        return CollectUtils.collect(planCourseWrappers, (Transformer)PlanCourseWrapper.UNWRAPPER);
    }

    private Collection<CourseTypeWrapper> wrapCourseTypes(Collection<String> courseTypes) {
        return CollectUtils.collect(courseTypes, (Transformer)CourseTypeWrapper.WRAPPER);
    }

    private Collection<String> unWrapCourseTypes(Collection<CourseTypeWrapper> courseTypeWrappers) {
        return CollectUtils.collect(courseTypeWrappers, (Transformer)CourseTypeWrapper.UNWRAPPER);
    }
}

