/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.service.impl;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import org.beangle.commons.bean.transformers.PropertyTransformer;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.functor.Transformer;
import org.openurp.base.edu.model.Calendar;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.service.SemesterService;

public class SemesterServiceImpl
extends BaseServiceImpl
implements SemesterService {
    @Override
    public Semester getSemester(Integer id) {
        Semester semester = (Semester)this.entityDao.get(Semester.class, (Serializable)id);
        return semester;
    }

    @Override
    public Calendar getCalendar(Project project) {
        return project.getCalendar();
    }

    @Override
    public List<Calendar> getCalendars(List<Project> projects) {
        List ids = CollectUtils.collect(projects, (Transformer)new PropertyTransformer("id"));
        OqlBuilder query = OqlBuilder.from(Project.class, (String)"project").where("project.id in (:projectIds))", (Object)ids);
        List ps = this.entityDao.search((QueryBuilder)query);
        Set calendars = CollectUtils.newHashSet();
        for (Project p : ps) {
            calendars.add(p.getCalendar());
        }
        return new ArrayList<Calendar>(calendars);
    }

    @Override
    public Semester getSemester(Project project, String schoolYear, String name) {
        Calendar calendar = this.getCalendar(project);
        return this.getSemester(calendar, schoolYear, name);
    }

    @Override
    public List<Semester> getSemestersOfOverlapped(Semester semester) {
        OqlBuilder builder = OqlBuilder.from(Semester.class, (String)"semester");
        builder.where("semester.beginOn <= :endOn", (Object)semester.getEndOn());
        builder.where("semester.endOn >= :beginOn", (Object)semester.getBeginOn());
        builder.cacheable(true);
        return this.entityDao.search((QueryBuilder)builder);
    }

    @Override
    public Semester getSemester(Calendar calendar, Date date) {
        Map params = CollectUtils.newHashMap();
        params.put("calendar", calendar);
        params.put("date", date);
        OqlBuilder builder = OqlBuilder.from(Semester.class, (String)"semester").where("semester.calendar=:calendar");
        builder.orderBy("abs(semester.beginOn - :date + semester.endOn - :date)");
        builder.params(params).cacheable();
        List rs = this.entityDao.search((QueryBuilder)builder);
        if (rs.size() < 1) {
            return null;
        }
        return (Semester)rs.get(0);
    }

    @Override
    public Semester getSemester(Calendar calendar, Date begOn, Date endOn) {
        Map params = CollectUtils.newHashMap();
        params.put("calendar", calendar);
        params.put("begOn", begOn);
        params.put("endOn", endOn);
        OqlBuilder builder = OqlBuilder.from(Semester.class, (String)"semester").where("semester.beginOn<=:endOn and semester.endOn>=:begOn and semester.calendar=:calendar").orderBy("semester.beginOn");
        builder.params(params);
        List rs = this.entityDao.search((QueryBuilder)builder);
        if (rs.size() < 1) {
            return null;
        }
        return (Semester)rs.get(0);
    }

    @Override
    public Semester getSemester(Calendar calendar, String schoolYear, String name) {
        OqlBuilder query = OqlBuilder.from(Semester.class, (String)"semester");
        query.where("semester.calendar = :calendar", (Object)calendar);
        query.where("semester.year.name = :schoolYear", (Object)schoolYear);
        query.where("semester.name = :name", (Object)name);
        List semesters = this.entityDao.search((QueryBuilder)query);
        if (semesters.isEmpty()) {
            return null;
        }
        return (Semester)semesters.get(0);
    }

    @Override
    public Semester getNextSemester(Semester semester) {
        OqlBuilder nextQuery = OqlBuilder.from(Semester.class, (String)"s");
        nextQuery.where("s.calendar=:calendar", (Object)semester.getCalendar());
        nextQuery.where("s.beginOn>:beginOn", (Object)semester.getEndOn()).orderBy("s.beginOn").limit(1, 1);
        List nexts = this.entityDao.search((QueryBuilder)nextQuery);
        if (nexts.isEmpty()) {
            return null;
        }
        return (Semester)nexts.get(0);
    }

    @Override
    public Semester getPreviousSemester(Calendar calendar) {
        HashMap<String, Calendar> params = new HashMap<String, Calendar>();
        params.put("calendar", calendar);
        List rs = this.entityDao.search("@getPreviousSemester", params);
        if (rs.size() < 1) {
            throw new EntityNotFoundException("without schoolYear for calendar id:" + String.valueOf((Object)calendar));
        }
        return (Semester)rs.get(0);
    }

    @Override
    public Semester getCurSemester(Calendar calendar) {
        OqlBuilder builder = OqlBuilder.from(Calendar.class, (String)"calender").where("calender.id = :calenderId", (Object)calendar.getId());
        builder.join("calender.semesters", "semester").where("semester.beginOn <= :date and semester.endOn >= :date", (Object)new java.util.Date());
        builder.select("semester");
        List rs = this.entityDao.search((QueryBuilder)builder);
        if (rs.size() == 1) {
            return (Semester)rs.get(0);
        }
        return calendar.getNearest();
    }

    @Override
    public Semester getCurSemester(Integer calendarId) {
        Calendar calendar = (Calendar)this.entityDao.get(Calendar.class, (Serializable)calendarId);
        if (null == calendar) {
            return null;
        }
        return this.getCurSemester(calendar);
    }

    @Override
    public int getTermsBetween(Semester first, Semester second, boolean omitSmallTerm) {
        if (!first.getCalendar().equals((Object)second.getCalendar())) {
            return 0;
        }
        OqlBuilder query = OqlBuilder.from(Semester.class, (String)"semester");
        query.select("count(semester.id)").where("semester.beginOn >= :firstStart").where("semester.beginOn <= :secondStart").where("semester.calendar = :calendar").where("((:omitSmallTerm = true and (year(semester.endOn) * 12 + month(semester.endOn)) - (year(semester.beginOn) * 12 + month(semester.beginOn)) > 2) or (:omitSmallTerm = false))");
        query.param("calendar", (Object)first.getCalendar());
        query.param("omitSmallTerm", (Object)new Boolean(omitSmallTerm));
        query.cacheable();
        Date firDate = first.getBeginOn();
        Date secDate = second.getBeginOn();
        if (first.after(second)) {
            GregorianCalendar calendar = new GregorianCalendar();
            query.param("firstStart", (Object)secDate);
            query.param("secondStart", (Object)firDate);
            return -((Number)this.entityDao.search((QueryBuilder)query).get(0)).intValue();
        }
        query.param("firstStart", (Object)firDate);
        query.param("secondStart", (Object)secDate);
        return ((Number)this.entityDao.search((QueryBuilder)query).get(0)).intValue();
    }

    @Override
    public void removeSemester(Semester semester) {
        this.entityDao.remove(new Object[]{semester});
    }

    @Override
    public void saveSemester(Semester semester) {
        if (null == semester) {
            return;
        }
        if (Strings.isEmpty((CharSequence)semester.getCode())) {
            semester.setCode(semester.getSchoolYear() + semester.getName());
        }
        this.entityDao.saveOrUpdate(new Object[]{semester});
    }

    @Override
    public boolean checkDateCollision(Semester semester) {
        if (null == semester) {
            return false;
        }
        OqlBuilder builder = OqlBuilder.from(Semester.class, (String)"semester");
        builder.where("semester.calendar=:calendar", (Object)semester.getCalendar());
        if (null != semester.getId()) {
            builder.where("id <> " + String.valueOf(semester.getId()));
        }
        List semesterList = this.entityDao.search((QueryBuilder)builder);
        for (Semester one : semesterList) {
            if (!semester.getBeginOn().before(one.getEndOn()) || !one.getBeginOn().before(semester.getEndOn())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Semester getCurSemester(Project project) {
        Calendar calendar = this.getCalendar(project);
        return this.getCurSemester(calendar);
    }

    @Override
    public Semester getNearestSemester(Project project) {
        Calendar calendar = this.getCalendar(project);
        return this.getNearestSemester(calendar);
    }

    @Override
    public Semester getNearestSemester(Calendar calendar) {
        List ss = this.entityDao.search("select id,schoolYear,name,endOn from " + Semester.class.getName(), new Object[0]);
        OqlBuilder query = OqlBuilder.from(Semester.class, (String)"semester");
        query.where("semester.calendar = :calendar", (Object)calendar).where("((semester.beginOn-current_date())*(semester.endOn-current_date())) <= all(select (c.beginOn-current_date())*(c.endOn-current_date())from  " + Semester.class.getName() + "as c where c.calendar =:calendar)", (Object)calendar);
        List semesters = this.entityDao.search((QueryBuilder)query);
        if (semesters.isEmpty()) {
            return null;
        }
        return (Semester)semesters.get(0);
    }

    @Override
    public List<Semester> getSemesters(Integer semesterStartId, Integer semesterEndId) {
        Semester semesterStart = new Semester();
        Semester semesterEnd = new Semester();
        if (semesterStartId != null) {
            semesterStart = (Semester)this.entityDao.get(Semester.class, (Serializable)semesterStartId);
        }
        if (semesterEndId != null) {
            semesterEnd = (Semester)this.entityDao.get(Semester.class, (Serializable)semesterEndId);
        }
        OqlBuilder builder = OqlBuilder.from(Semester.class, (String)"semester");
        if (semesterStartId != null && semesterEndId == null) {
            builder.where("semester.beginOn >= :startTime", (Object)semesterStart.getBeginOn());
        }
        if (semesterStartId == null && semesterEndId != null) {
            builder.where("semester.beginOn <= :endTime", (Object)semesterEnd.getBeginOn());
        }
        if (semesterStartId != null && semesterEndId != null) {
            builder.where("semester.beginOn >= :startTime", (Object)semesterStart.getBeginOn());
            builder.where("semester.beginOn <= :endTime", (Object)semesterEnd.getBeginOn());
        }
        ArrayList<Semester> semesterList = new ArrayList();
        semesterList = this.entityDao.search((QueryBuilder)builder);
        return semesterList;
    }

    @Override
    public Semester getPrevSemester(Semester semester) {
        OqlBuilder query = OqlBuilder.from(Semester.class, (String)"semester").where("semester.calendar = :calendar", (Object)semester.getCalendar()).where("semester.endOn < (select cur.beginOn from " + Semester.class.getName() + " cur where cur.id = :curId)", (Object)semester.getId()).orderBy("semester.endOn desc").cacheable();
        List semesters = this.entityDao.search((QueryBuilder)query);
        if (CollectUtils.isNotEmpty((Collection)semesters)) {
            return (Semester)semesters.get(0);
        }
        return null;
    }
}

