/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.model;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.metadata.Model;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.ProjectBasedObject;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.hr.model.Teacher;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.code.edu.model.ClazzTag;
import org.openurp.code.edu.model.CourseType;
import org.openurp.code.edu.model.ExamMode;
import org.openurp.code.edu.model.TeachLangType;
import org.openurp.edu.clazz.model.ClazzActivity;
import org.openurp.edu.clazz.model.ClazzGroup;
import org.openurp.edu.clazz.model.ClazzRestriction;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.clazz.model.Enrollment;
import org.openurp.edu.clazz.model.Schedule;

@Entity(name="org.openurp.edu.clazz.model.Clazz")
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"crn", "semester_id", "project_id"})})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
public class Clazz
extends ProjectBasedObject<Long>
implements Cloneable {
    private static final long serialVersionUID = 1071972497531228225L;
    @Size(max=32)
    private String crn;
    @NotNull
    @Size(max=4000)
    private String clazzName;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Course course;
    @Size(max=200)
    private String subject;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseType courseType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Department teachDepart;
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    @OrderColumn(name="idx", insertable=true, updatable=true, nullable=false)
    private List<Teacher> teachers = new ArrayList<Teacher>();
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private List<ClazzTag> tags = new ArrayList<ClazzTag>();
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Campus campus;
    @Target(value=Enrollment.class)
    private Enrollment enrollment;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Semester semester;
    private Schedule schedule;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private TeachLangType langType;
    @ManyToOne(fetch=FetchType.LAZY)
    private ClazzGroup group;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamMode examMode;
    private boolean hasMakeup;
    @NotNull
    @Type(type="org.beangle.orm.hibernate.udt.IDEnumType")
    private AuditStatus status = AuditStatus.UNSUBMITTED;
    @Size(max=500)
    private String remark;
    private Long planId;

    public Clazz() {
    }

    public Clazz(Long lessonId) {
        this.id = lessonId;
    }

    public static Clazz getDefault() {
        Clazz task = (Clazz)Model.newInstance(Clazz.class);
        task.setEnrollment(new Enrollment());
        task.setSchedule(new Schedule());
        return task;
    }

    public Date getFirstCourseTime() {
        if (null != this.semester && this.semester.isPersisted()) {
            Date date = null;
            if (null != this.getSchedule().getActivities()) {
                for (ClazzActivity session : this.getSchedule().getActivities()) {
                    Date myDate = session.getFirstActivityTime();
                    if (date != null && !myDate.before(date)) continue;
                    date = myDate;
                }
            }
            return date;
        }
        return null;
    }

    public Date getLastCourseTime() {
        if (null != this.semester && this.semester.isPersisted()) {
            Date date = null;
            if (null != this.getSchedule().getActivities()) {
                for (ClazzActivity session : this.getSchedule().getActivities()) {
                    Date myDate = session.getLastActivityTime();
                    if (date != null && !myDate.after(date)) continue;
                    date = myDate;
                }
            }
            return date;
        }
        return null;
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public Course getCourse() {
        return this.course;
    }

    public void setCourse(Course course) {
        this.course = course;
    }

    public String getCrn() {
        return this.crn;
    }

    public void setCrn(String crn) {
        this.crn = crn;
    }

    public CourseType getCourseType() {
        return this.courseType;
    }

    public void setCourseType(CourseType courseType) {
        this.courseType = courseType;
    }

    public Enrollment getEnrollment() {
        return this.enrollment;
    }

    public void setEnrollment(Enrollment enrollment) {
        this.enrollment = enrollment;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String toString() {
        return " [id:" + String.valueOf(this.getId()) + "]  " + this.getCourse().getName() + " " + this.getClazzName();
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public List<Teacher> getTeachers() {
        return this.teachers;
    }

    public void setTeachers(List<Teacher> teachers) {
        this.teachers = teachers;
    }

    public Campus getCampus() {
        return this.campus;
    }

    public void setCampus(Campus campus) {
        this.campus = campus;
    }

    public String getTeacherNames() {
        if (null != this.getTeachers() && !this.getTeachers().isEmpty()) {
            StringBuffer buf = new StringBuffer(10);
            for (Teacher teacher : this.getTeachers()) {
                buf.append(teacher.getName()).append(",");
            }
            buf.deleteCharAt(buf.length() - 1);
            return buf.toString();
        }
        return "";
    }

    public String getTeacherNamesWithCode() {
        if (null != this.getTeachers() && !this.getTeachers().isEmpty()) {
            StringBuffer buf = new StringBuffer(10);
            for (Teacher teacher : this.getTeachers()) {
                buf.append(teacher.getName()).append("[").append(teacher.getCode()).append("]").append(",");
            }
            buf.deleteCharAt(buf.length() - 1);
            return buf.toString();
        }
        return "";
    }

    public Department getTeachDepart() {
        return this.teachDepart;
    }

    public void setTeachDepart(Department teachDepart) {
        this.teachDepart = teachDepart;
    }

    public TeachLangType getLangType() {
        return this.langType;
    }

    public void setLangType(TeachLangType langType) {
        this.langType = langType;
    }

    public List<ClazzTag> getTags() {
        return this.tags;
    }

    public void setTags(List<ClazzTag> tags) {
        this.tags = tags;
    }

    public ClazzGroup getGroup() {
        return this.group;
    }

    public void setGroup(ClazzGroup group) {
        this.group = group;
    }

    public AuditStatus getStatus() {
        return this.status;
    }

    public void setStatus(AuditStatus status) {
        this.status = status;
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public void setClazzName(String clazzName) {
        this.clazzName = clazzName;
    }

    public Clazz clone() {
        try {
            Clazz one = (Clazz)super.clone();
            one.setId(null);
            one.setCrn(null);
            one.setGroup(null);
            one.setTags(new ArrayList<ClazzTag>());
            one.getTags().addAll(this.getTags());
            one.setTeachers(CollectUtils.newArrayList());
            one.getTeachers().addAll(this.getTeachers());
            one.setSchedule(this.getSchedule().clone());
            one.setEnrollment(this.getEnrollment().clone());
            for (CourseTaker taker : one.getEnrollment().getCourseTakers()) {
                taker.setClazz(one);
            }
            for (ClazzRestriction group : one.getEnrollment().getRestrictions()) {
                group.setClazz(one);
            }
            Date createdAt = new Date(System.currentTimeMillis());
            one.setUpdatedAt(createdAt);
            return one;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public ExamMode getExamMode() {
        return this.examMode;
    }

    public void setExamMode(ExamMode examMode) {
        this.examMode = examMode;
    }

    public boolean isHasMakeup() {
        return this.hasMakeup;
    }

    public void setHasMakeup(boolean hasMakeup) {
        this.hasMakeup = hasMakeup;
    }

    public Long getPlanId() {
        return this.planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }
}

