/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exam.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.text.i18n.TextResource;
import org.beangle.orm.hibernate.udt.WeekDay;
import org.openurp.base.edu.model.WeekTimeBuilder;
import org.openurp.edu.exam.model.ExamActivity;
import org.openurp.edu.exam.model.ExamRoom;

public class ExamActivityDigestor {
    public static final String singleTeacher = ":teacher1";
    public static final String multiTeacher = ":teacher+";
    public static final String moreThan1Teacher = ":teacher2";
    public static final String day = ":day";
    public static final String date = ":date";
    public static final String units = ":units";
    public static final String weeks = ":weeks";
    public static final String time = ":time";
    public static final String room = ":room";
    public static final String building = ":building";
    public static final String district = ":district";
    public static final String defaultFormat = ":date :time \u7b2c:weeks\u5468 :day";
    public static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private String delimeter = ",";

    private ExamActivityDigestor() {
    }

    public static ExamActivityDigestor getInstance() {
        return new ExamActivityDigestor();
    }

    public String digest(ExamActivity activity, TextResource resource) {
        return this.digest(activity, resource, defaultFormat);
    }

    public String digest(ExamActivity activity, TextResource resource, String format) {
        if (null == activity) {
            return "";
        }
        if (Strings.isEmpty((CharSequence)format)) {
            format = defaultFormat;
        }
        boolean hasRoom = Strings.contains((CharSequence)format, (CharSequence)room);
        boolean hasTeacher = Strings.contains((CharSequence)format, (CharSequence)"teacher");
        StringBuffer arrangeInfoBuf = new StringBuffer();
        for (ExamRoom examRoom : activity.getRooms()) {
            arrangeInfoBuf.append(format);
            int replaceStart = 0;
            replaceStart = arrangeInfoBuf.indexOf(day);
            if (-1 != replaceStart) {
                WeekDay weekday = WeekDay.of((Date)activity.getExamOn());
                arrangeInfoBuf.replace(replaceStart, replaceStart + day.length(), weekday.getName());
            }
            if (-1 != (replaceStart = arrangeInfoBuf.indexOf(units))) {
                // empty if block
            }
            if (-1 != (replaceStart = arrangeInfoBuf.indexOf(time))) {
                arrangeInfoBuf.replace(replaceStart, replaceStart + time.length(), activity.getBeginAt().toString() + "-" + activity.getEndAt().toString());
            }
            if (-1 != (replaceStart = arrangeInfoBuf.indexOf(date))) {
                arrangeInfoBuf.replace(replaceStart, replaceStart + date.length(), df.format(activity.getExamOn()));
            }
            if (-1 != (replaceStart = arrangeInfoBuf.indexOf(weeks))) {
                arrangeInfoBuf.replace(replaceStart, replaceStart + weeks.length(), "" + WeekTimeBuilder.weekIndexOf(examRoom.getSemester(), activity.getExamOn()));
            }
            if (-1 != (replaceStart = arrangeInfoBuf.indexOf(room))) {
                arrangeInfoBuf.replace(replaceStart, replaceStart + room.length(), null != examRoom.getRoom() ? examRoom.getRoom().getName() : "");
                replaceStart = arrangeInfoBuf.indexOf(building);
                if (-1 != replaceStart) {
                    if (null != examRoom.getRoom() && null != examRoom.getRoom().getBuilding()) {
                        arrangeInfoBuf.replace(replaceStart, replaceStart + building.length(), examRoom.getRoom().getBuilding().getName());
                    } else {
                        arrangeInfoBuf.replace(replaceStart, replaceStart + building.length(), "");
                    }
                }
                if (-1 != (replaceStart = arrangeInfoBuf.indexOf(district))) {
                    if (null != examRoom.getRoom() && null != examRoom.getRoom().getBuilding() && null != examRoom.getRoom().getBuilding().getCampus()) {
                        arrangeInfoBuf.replace(replaceStart, replaceStart + district.length(), examRoom.getRoom().getBuilding().getCampus().getName());
                    } else {
                        arrangeInfoBuf.replace(replaceStart, replaceStart + district.length(), "");
                    }
                }
            }
            arrangeInfoBuf.append(this.delimeter);
        }
        if (arrangeInfoBuf.lastIndexOf(this.delimeter) != -1) {
            arrangeInfoBuf.delete(arrangeInfoBuf.lastIndexOf(this.delimeter), arrangeInfoBuf.length());
        }
        return arrangeInfoBuf.toString();
    }

    public ExamActivityDigestor setDelimeter(String delimeter) {
        this.delimeter = delimeter;
        return this;
    }
}

