/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service;

import java.util.Collection;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.Operation;
import org.openurp.code.edu.model.GradeType;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.model.CourseGradeState;
import org.openurp.edu.grade.course.service.CourseGradePublishListener;

public class CourseGradePublishStack {
    protected List<CourseGradePublishListener> listeners = CollectUtils.newArrayList();

    public List<Operation> onPublish(CourseGrade grade, GradeType[] gradeTypes) {
        List results = CollectUtils.newArrayList();
        for (CourseGradePublishListener listener : this.listeners) {
            results.addAll(listener.onPublish(grade, gradeTypes));
        }
        return results;
    }

    public List<Operation> onPublish(Collection<CourseGrade> grades, CourseGradeState gradeState, GradeType[] gradeTypes) {
        List results = CollectUtils.newArrayList();
        for (CourseGradePublishListener listener : this.listeners) {
            results.addAll(listener.onPublish(grades, gradeState, gradeTypes));
        }
        return results;
    }

    public void setListeners(List<CourseGradePublishListener> publishListeners) {
        this.listeners = publishListeners;
    }
}

